/* To wrap a player the develop should create a new class derived from 
   the IriSP.PopcornReplacement.player and defining the correct functions */

/** youtube player wrapper */
IriSP.PopcornReplacement.youtube = function(container, options) {

  /* appel du parent pour initialiser les structures communes à tous les players */
  IriSP.PopcornReplacement.player.call(this, container, options);
  
  this.media.duration = options.duration; /* optional */
  var _this = this;
  
  /* Définition des fonctions de l'API -  */
  this.playerFns = {
    play: function() { return _this.player.playVideo(); },
    pause: function() { return _this.player.pauseVideo(); },
    getPosition: function() { console.log("ho"); return _this.player.getCurrentTime(); },
    seek: function(pos) { return _this.player.seekTo(pos, true); },
    getMute: function() { return _this.player.isMuted(); },
    setMute: function(p) { return _this.player.mute(p); }
  }

  window.onYouTubePlayerReady = IriSP.wrap(this, this.ready);
  
  options.events = this.callbacks;
  var params = { allowScriptAccess: "always" };
  var atts = { id: container };
  swfobject.embedSWF("http://www.youtube.com/apiplayer?enablejsapi=1&version=3",
                     container, options.width, options.height, "8", null, null, params, atts);

  
};

IriSP.PopcornReplacement.youtube.prototype = new IriSP.PopcornReplacement.player("", {});

IriSP.PopcornReplacement.youtube.prototype.ready = function() {
  // save the player dom object.
  this.player = IriSP.jQuery("#" + this.container).get(0);
  // crap - youtube player expects a string describing the function to call.
  this.player.addEventListener("onStateChange", "IriSP.PopcornReplacement.youtube.prototype.stateHandler");
  this.player.loadVideoByUrl("http://www.youtube.com/v/ucc58jIasI8?version=3");
  
};


/* we've got to store the previous state in the prototype because, well
   the youtube player is crap */
IriSP.PopcornReplacement.youtube.prototype.previousState = -1;

IriSP.PopcornReplacement.youtube.prototype.stateHandler = function(state) {
  if (state === 1) // playing { 
    /* we're already playing */
    
    if (IriSP.PopcornReplacement.youtube.prototype.previousState === state) {
      var time = this.player.getCurrentTime();
      console.log(time);
      this.callbacks.onTime({position: time});
    } else { /* we're entering the playing state */
      this.callbacks.onPlay();
    }
  else if (state === 2) // paused
    this.callbacks.onPause();
  else if (state === 3) // buffering
    this.callbacks.onSeek();
  
  else if (state === 5) /* video ready to play */
    this.callbacks.onReady();
  
  IriSP.PopcornReplacement.youtube.prototype.previousState = state;
};