﻿package bab.player
{
	import bab.player.events.EditEvent;
	
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.EventDispatcher;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	
	import bab.player.FlvPlayer;
	
	
	public class EditSkin extends EventDispatcher
	{
		
		//private var flvP:FlvPlayer;
		private var skinMc:MovieClip;
		private var playBtn:SimpleButton;
		private var pauseBtn:SimpleButton;
		private var backBtn:SimpleButton;
		private var forwardBtn:SimpleButton;
		private var volBtn:Sprite;
		private var volBar:Sprite;
		
		private var xVol:uint;
		private var yVol:uint;
		private var curVol:Number;
		
		public function EditSkin(f:FlvPlayer)
		{
			//flvP = f;
			skinMc = f.babSkin;
			//trace("babSkin 2 = " + skinMc.play_mc + ", " + skinMc.pause_mc + ", " + skinMc.back_mc + ", " + skinMc.forward_mc + ", " + skinMc.volumeBarHandle_mc + ", " + skinMc.volumeBar_mc);
			playBtn = skinMc.play_mc;
			pauseBtn = skinMc.pause_mc;
			pauseBtn.visible = false;
			backBtn = skinMc.back_mc;
			forwardBtn = skinMc.forward_mc;
			volBtn = skinMc.volumeBarHandle_mc;
			volBtn.buttonMode = true;
			xVol = volBtn.x;
			volBtn.x = xVol + 50*f.volume;
			//trace("volBtn.x : " + volBtn.x); 
			yVol = volBtn.y;
			volBar = skinMc.volumeBar_mc.fullness_mc.fill_mc;
			volBar.useHandCursor = volBar.buttonMode = true;
			skinMc.volumeBar_mc.fullness_mc.fill_mc.mouseEnabled = false;
			skinMc.volumeBar_mc.fullness_mc.mouseEnabled = false;
			skinMc.volumeBar_mc.hit_mc.mouseEnabled = false;
			skinMc.volumeBar_mc.mouseEnabled = false;
			
			// <TEMP> while the volume management has not been coded
			volBtn.visible = skinMc.volumeBar_mc.visible = true;
			// </TEMP>
			
			playBtn.addEventListener(MouseEvent.CLICK, playPauseHandler);
			pauseBtn.addEventListener(MouseEvent.CLICK, playPauseHandler);
			backBtn.addEventListener(MouseEvent.CLICK, backHandler);
			forwardBtn.addEventListener(MouseEvent.CLICK, forwardHandler);
			volBtn.addEventListener(MouseEvent.MOUSE_DOWN, startVolHandler);
			volBar.addEventListener(MouseEvent.MOUSE_DOWN, startVolHandler);
			
		}
		
		//
		// Mouse Event handlers
		//
		private function playPauseHandler(e:MouseEvent=null):void{
			dispatchEvent(new EditEvent(EditEvent.EDIT_PLAYPAUSE, curVol));
		}
		private function backHandler(e:MouseEvent=null):void{
			dispatchEvent(new EditEvent(EditEvent.EDIT_BACK, curVol));
		}
		private function forwardHandler(e:MouseEvent=null):void{
			dispatchEvent(new EditEvent(EditEvent.EDIT_FORWARD, curVol));
		}
		private function startVolHandler(e:MouseEvent=null):void{
			//trace("startVolHandler");
			volBtn.startDrag(false,new Rectangle(xVol,yVol,50,0));
			volBtn.stage.addEventListener(MouseEvent.MOUSE_MOVE,updateSound);
			volBtn.stage.addEventListener(MouseEvent.MOUSE_UP, stopVolHandler);
		}
		private function stopVolHandler(e:MouseEvent=null):void{

			volBtn.stopDrag();
			volBtn.stage.removeEventListener(MouseEvent.MOUSE_MOVE,updateSound);
			volBtn.stage.removeEventListener(MouseEvent.MOUSE_UP, stopVolHandler);
			volBtn.buttonMode = true;
			// We dispatch the event only at the end
		}
		private function updateSound(e:MouseEvent=null):void{
			//trace("xVol : " + xVol);
			//trace("volBtn.x : "+ volBtn.x);
			volBar.width = volBtn.x - xVol;
			//trace("volBar.width : " + volBar.width);
			curVol = (100 / 50) * (volBtn.x - xVol);
			dispatchEvent(new EditEvent(EditEvent.EDIT_SOUNDUPDATE, curVol/100));
		}
		
		//
		// Enable to switch display between play and pause buttons
		//
		public function set isPlaying(b:Boolean):void{
			
			if(b==true){
				playBtn.visible = false;
				pauseBtn.visible = true;
			}
			else if(b==false){
				playBtn.visible = true;
				pauseBtn.visible = false;
			}
			
		}
		
		public function setVolume(vol:Number):void{
			volBtn.x = xVol + 50*vol;
			volBar.width = volBtn.x - xVol;
			//trace("setVolume, vol : " + vol);
			dispatchEvent(new EditEvent(EditEvent.EDIT_SOUNDUPDATE, vol));
		}
		

	}
}