/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.net.sf.retrotranslator.runtime.format;

import java.math.BigInteger;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.format.FormatContext;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.format.NumericConversion;

abstract class NondecimalIntegralConversion
extends NumericConversion {
    NondecimalIntegralConversion() {
    }

    public void format(FormatContext context) {
        context.checkWidth();
        context.assertNoPrecision();
        context.assertNoFlag(',');
        context.checkFlags();
        Object argument = context.getArgument();
        if (argument instanceof Byte) {
            this.printf(context, ((Byte)argument).byteValue(), 8);
        } else if (argument instanceof Short) {
            this.printf(context, ((Short)argument).shortValue(), 16);
        } else if (argument instanceof Integer) {
            this.printf(context, ((Integer)argument).intValue(), 32);
        } else if (argument instanceof Long) {
            this.printf(context, (Long)argument, 64);
        } else if (argument instanceof BigInteger) {
            this.printf(context, (BigInteger)argument);
        } else if (argument == null) {
            context.writePadded(String.valueOf(argument));
        } else {
            throw context.getConversionException();
        }
    }

    private void printf(FormatContext context, long argument, int size) {
        context.assertNoFlag('(');
        context.assertNoFlag(' ');
        context.assertNoFlag('+');
        long value = argument >= 0L || size == 64 ? argument : argument + (1L << size);
        this.printf(context, false, this.toUnsignedString(value));
    }

    private void printf(FormatContext context, BigInteger argument) {
        this.printf(context, argument.signum() < 0, this.toSignedString(argument.abs()));
    }

    private void printf(FormatContext context, boolean negative, String value) {
        String prefix = context.isFlag('#') ? this.getRadixIndicator() : null;
        NondecimalIntegralConversion.printNumber(context, negative, prefix, new StringBuffer(value), context.getSymbols(false));
    }

    protected abstract String getRadixIndicator();

    protected abstract String toUnsignedString(long var1);

    protected abstract String toSignedString(BigInteger var1);

    public static class HexadecimalConversion
    extends NondecimalIntegralConversion {
        protected String getRadixIndicator() {
            return "0x";
        }

        protected String toUnsignedString(long value) {
            return Long.toHexString(value);
        }

        protected String toSignedString(BigInteger value) {
            return value.toString(16);
        }
    }

    public static class OctalConversion
    extends NondecimalIntegralConversion {
        protected String getRadixIndicator() {
            return "0";
        }

        protected String toUnsignedString(long value) {
            return Long.toOctalString(value);
        }

        protected String toSignedString(BigInteger value) {
            return value.toString(8);
        }
    }
}

