import Mustache from "mustache";
import slidePreviewStyles from "./SlidePreview.module.css";
import jQuery from "jquery";

const SlidePreview = function (ns) {
  return class extends ns.Widgets.Widget {
    constructor(player, config) {
      super(player, config);
    }

    static defaults = {
      annotation_type: "Slides",
    };

    static template =
      '<div class="Ldt-SlidePreview-Container"><div class="Ldt-SlidePreview-Slides"></div></div>';

    static annotationTemplate =
      '<div data-id="{{ id }}" data-timecode="{{ ms }}" class="Ldt-SlidePreview-Item"><img title="{{ begin }} - {{ atitle }}" class="Ldt-AnnotationsList-Thumbnail" src="{{ thumbnail }}"></div>';

    draw() {
      var _annotations = this.getWidgetAnnotations().sortBy(function (
        _annotation
      ) {
        return _annotation.begin;
      });
      var _this = this;
      _this.renderTemplate();
      var content = _this.$.find(".Ldt-SlidePreview-Slides");

      this.getWidgetAnnotations().forEach(function (_a) {
        var _data = {
          id: _a.id,
          content: ns.textFieldHtml(_a.title),
          begin: _a.begin.toString(),
          ms: _a.begin.milliseconds,
          thumbnail: _a.thumbnail,
        };
        var _html = Mustache.render(_this.annotationTemplate, _data);
        var _el = jQuery(_html);
        content.append(_el);
      });
      _this.$.on("click", ".Ldt-SlidePreview-Item", function () {
        _this.media.setCurrentTime(Number(this.dataset.timecode));
      });
    }
  };
};

export { SlidePreview, slidePreviewStyles };
