﻿package bab.player
{
	import fl.video.VideoEvent;
	
	import flash.display.DisplayObjectContainer;
	import flash.display.Loader;
	import flash.display.SimpleButton;
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.MouseEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.utils.Timer;
	
	//import mx.controls.Alert;

	public class ExternalPlayer extends EventDispatcher
	{
		private var curParent:DisplayObjectContainer;
		
		private var player:Object;
		private var playerYT:Object;
		private var playerDM:Object;
		 
		private var playBtn:SimpleButton;
		private var pauseBtn:SimpleButton;
		private var volPlus:SimpleButton;
		private var volMinus:SimpleButton;
		
		private var playheadTimer:Timer;
		
		private var urlToLoad:String;
		
		private var sizeUpdated:Boolean = false;
		
		public static function get EXTERNALPLAYER_RATIO():Number{
			return 1.6;
		}
		
		public function ExternalPlayer(prnt:DisplayObjectContainer, url:String="")
		{
			Security.allowDomain("*");
			Security.allowInsecureDomain("*");
			
			curParent = prnt;
			
			// Simple button Play
			var t:TextField = new TextField();
			t.text = "PLAY";
			t.autoSize = "left";
			playBtn = new SimpleButton(t,t,t,t);
			playBtn.useHandCursor = playBtn.mouseEnabled = true;
			prnt.addChild(playBtn);
			// Simple button Pause
			var t2:TextField = new TextField();
			t2.text = "PAUSE";
			t2.autoSize = "left";
			pauseBtn = new SimpleButton(t2,t2,t2,t2);
			pauseBtn.useHandCursor = pauseBtn.mouseEnabled = true;
			prnt.addChild(pauseBtn);
			// Simple button Volume +
			var t3:TextField = new TextField();
			t3.text = "Vol + /";
			t3.autoSize = "left";
			volPlus = new SimpleButton(t3,t3,t3,t3);
			volPlus.useHandCursor = volPlus.mouseEnabled = true;
			prnt.addChild(volPlus);
			// Simple button Pause
			var t4:TextField = new TextField();
			t4.text = "Vol -";
			t4.autoSize = "left";
			volMinus = new SimpleButton(t4,t4,t4,t4);
			volMinus.useHandCursor = volMinus.mouseEnabled = true;
			prnt.addChild(volMinus);
			
			pauseBtn.x = 50;
			volPlus.x = 200; 
			volMinus.x = 235;
			
			// Play pause listeners
			playBtn.addEventListener(MouseEvent.CLICK, onBtnClick);
			pauseBtn.addEventListener(MouseEvent.CLICK, onBtnClick);
			// Volume listeners
			volPlus.addEventListener(MouseEvent.CLICK, onVolClick);
			volMinus.addEventListener(MouseEvent.CLICK, onVolClick);
			
			loadVideo(url);
			
		}
		
		//
		// Load Players
		//
		private function loadYTPlayer():void{
			// Youtube loader
			var l:Loader = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadYTCLP);
			l.addEventListener(ErrorEvent.ERROR, onError, true);
			l.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError, true);
			l.contentLoaderInfo.addEventListener(ErrorEvent.ERROR, onError, true);
			l.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError, true);
			l.load(new URLRequest("http://www.youtube.com/apiplayer?version=3"));
			// The parent will load;
			curParent.addChild(l);
		}
		private function loadDMPlayer():void{
			// Dailymotion loader
			var l:Loader = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadDMCLP);
			l.addEventListener(ErrorEvent.ERROR, onError, true);
			l.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError, true);
			l.contentLoaderInfo.addEventListener(ErrorEvent.ERROR, onError, true);
			l.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError, true);
			l.load(new URLRequest("http://www.dailymotion.com/swf?enableApi=1&chromeless=1"));
			// The parent will load;
			curParent.addChild(l);
		}
		
		//
		// OnLoad Players management
		//
		private function onLoadYTCLP(e:Event):void {
			//addChild(loader);
			playerYT = e.target.content; 
			playerYT.addEventListener(ErrorEvent.ERROR, onError);
			playerYT.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
			playerYT.addEventListener("onReady", onYTPlayerReady);
			playerYT.addEventListener("onError", onYTPlayerError);
			playerYT.addEventListener("onStateChange", onYTStateChange);
			//YTPlayer.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
		}
		private function onLoadDMCLP(e:Event):void {
			//addChild(loader);
			playerDM = e.target.content; 
			playerDM.addEventListener(ErrorEvent.ERROR, onError);
			playerDM.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
			playerDM.addEventListener("onReady", onYTPlayerReady);
			playerDM.addEventListener("onError", onYTPlayerError);
			playerDM.addEventListener("onStateChange", onYTStateChange);
			//YTPlayer.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
		}
		
		//
		// Player event management
		//
		private function onYTPlayerReady(o:Object):void {
		    // Event.data contains the event parameter, which is the Player API ID
		    trace("player ready:" + o.data);
		    // Once this event has been dispatched by the player, we can use
		    // cueVideoById, loadVideoById, cueVideoByUrl and loadVideoByUrl
		    // to load a particular YouTube video.
			loadVideo(urlToLoad);
		}
		private function onYTPlayerError(o:Object):void {
		    // Event.data contains the event parameter, which is the error code
		    trace("player error:", o.data);
		}
		private function onYTStateChange(o:Object):void {
		    // Event.data contains the event parameter, which is the new player state
		    trace("player state:" + o.data + (o.data==1) + (o.data=="1"));
		    // o.data : unstarted (-1), ended (0), playing (1), paused (2), buffering (3), video cued (5)
		    if(o.data==1 || o.data=="1" || o.data==3 || o.data=="3"){
		    	// When the YTplayer enters in play state, it sends 1 or 3. 
		    	if(playheadTimer!=null){
		    		playheadTimer.stop();
		    		playheadTimer = null;
		    	}
    			playheadTimer = new Timer(500, 3600*2);
    			playheadTimer.addEventListener(TimerEvent.TIMER, onTimer);
    			playheadTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
    			playheadTimer.start();
		    }
		    else{
		    	// When the YTplayer enters in play state, it sends 1 or 3. 
		    	if(playheadTimer!=null){
		    		playheadTimer.stop();
		    		playheadTimer = null;
		    	}
		    }
		    // When the video has been loaded, we ask a resize to the manager
		    if(!sizeUpdated && o.data!=-1 && o.data!="-1"){
		    	dispatchEvent(new VideoEvent(VideoEvent.READY));
		    }
		}
		
		//
		// Size matters
		//
		public function setSize(w:Number, h:Number):void{
			if(player!=null){
				//trace("setSize " + w + ", " + h);
				if(player.setSize) player.setSize(EXTERNALPLAYER_RATIO*Math.max(h,242),Math.max(h,242));
				playBtn.y = pauseBtn.y = volPlus.y = volMinus.y = Math.max(h,240) + 10;
			}
		}
		
		//
		// Play/pause mangement
		//
		private function onBtnClick(e:MouseEvent):void{
			if(e.target==playBtn) play();
			else if(e.target==pauseBtn) pause();
		}
		
		//
		// Play/pause mangement
		//
		public function play():void{
			if(player!=null){
				player.playVideo();
			}
		}
		public function pause():void{
			if(player!=null){
				player.pauseVideo();
			}
		}
		
		//
		// Timer management
		//
		private function onTimer(e:TimerEvent):void{
			//trace("onTimer");
			if(player!=null){
				//trace("onTimer 2 " + player.getCurrentTime());
				dispatchEvent(new VideoEvent(VideoEvent.PLAYHEAD_UPDATE, false, false, "playing", player.getCurrentTime()));
			}
		}
		private function onTimerComplete(e:TimerEvent):void{
			// nothing to do
		}
		
		//
		// Visible management
		//
		public function set visible(b:Boolean):void{
			if(player!=null){
				player.visible = playBtn.visible = pauseBtn.visible = volMinus.visible = volPlus.visible = b;
				if(!b) pause();
			}
		}
		public function get visible():Boolean{
			if(player!=null){
				return player.visible;
			}
			return false;
		}
		
		//
		// Volume management
		//
		private function onVolClick(e:MouseEvent):void{
			if(player!=null){
				if(e.target==volPlus) player.setVolume(Math.min(100, player.getVolume()+10));
				else if(e.target==volMinus) player.setVolume(Math.max(0, player.getVolume()-10));
			}
		}
		
		//
		// Url management
		//
		public function loadVideo(url:String):void{
			var id:String = "";
			if(url!=""&& url.search("youtube")>-1){
				if(playerYT!=null){
					// A valid youtube url is like : http://www.youtube.com/watch?v=PgEu923nxSE or http://www.youtube.com/v/PgEu923nxSE
					// The idea is to get the id from the url. The id is ALWAYS 11 characters.
					if(url.search("v=")>-1) id = url.substr(url.search("v=")+2, 11);
					else if(url.search("v/")>-1) id = url.substr(url.search("v/")+2, 11);
					sizeUpdated = false;
					player = playerYT;
					if(id!="" && id.length==11) player.loadVideoById(id);
					//else Alert.show("Youtube URL must be like\nhttp://www.youtube.com/watch?v=VIDEO_ID", "Attention");
					//player.loadVideoById("PgEu923nxSE"); // Stiegler
					//player.loadVideoById("7xzU9Qqdqww"); // Kid Cudi - Pursuit Of Happiness ft. Ratatat
				}
				else{
					urlToLoad = url;
					loadYTPlayer();
				}
			}
			else if(url!=""&& url.search("dailymotion")>-1){
				if(playerDM!=null){
					// A valid DM url is like : http://www.dailymotion.com/video/VIDEO_ID
					// The idea is to get the id from the url.
					if(url.search("video/")>-1) id = url.substr(url.search("video/")+6);
					sizeUpdated = false;
					player = playerDM;
					if(id!="") player.loadVideoById(id);
					//else Alert.show("Dailymotion URL must be like\nhttp://www.dailymotion.com/video/VIDEO_ID", "Attention");
					//player.loadVideoById("PgEu923nxSE"); // Stiegler
					//player.loadVideoById("7xzU9Qqdqww"); // Kid Cudi - Pursuit Of Happiness ft. Ratatat
				}
				else{
					urlToLoad = url;
					loadDMPlayer();
				}
			}
		}
		
		//
		// Seek management
		//
		public function goTo(tc:Number, paramPlay:Boolean):void{
			if(player!=null){
				 //player.seekTo(tc, paramPlay);
				 if(player==playerYT) player.seekTo(tc, true);
				 else if(player==playerDM) player.seekTo(tc);
			}
		}
			
		//
		// Trying to catch the sandbox errors but does not work...
		//
		public function onError(er:*):void{
			// do nothing
			trace("onError " + er);
		}
		
	}
}