/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;

public class P4Resolve
extends P4Base {
    private String resolvemode = null;
    private boolean redoall;
    private boolean simulationmode;
    private boolean forcetextmode;
    private boolean markersforall;
    private static final String AUTOMATIC = "automatic";
    private static final String FORCE = "force";
    private static final String SAFE = "safe";
    private static final String THEIRS = "theirs";
    private static final String YOURS = "yours";
    private static final String[] RESOLVE_MODES = new String[]{"automatic", "force", "safe", "theirs", "yours"};

    public String getResolvemode() {
        return this.resolvemode;
    }

    public void setResolvemode(String resolvemode) {
        boolean found = false;
        for (int counter = 0; counter < RESOLVE_MODES.length; ++counter) {
            if (!resolvemode.equals(RESOLVE_MODES[counter])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new BuildException("Unacceptable value for resolve mode");
        }
        this.resolvemode = resolvemode;
    }

    public boolean isRedoall() {
        return this.redoall;
    }

    public void setRedoall(boolean redoall) {
        this.redoall = redoall;
    }

    public boolean isSimulationmode() {
        return this.simulationmode;
    }

    public void setSimulationmode(boolean simulationmode) {
        this.simulationmode = simulationmode;
    }

    public boolean isForcetextmode() {
        return this.forcetextmode;
    }

    public void setForcetextmode(boolean forcetextmode) {
        this.forcetextmode = forcetextmode;
    }

    public boolean isMarkersforall() {
        return this.markersforall;
    }

    public void setMarkersforall(boolean markersforall) {
        this.markersforall = markersforall;
    }

    public void execute() throws BuildException {
        if (this.resolvemode.equals(AUTOMATIC)) {
            this.P4CmdOpts = this.P4CmdOpts + " -am";
        } else if (this.resolvemode.equals(FORCE)) {
            this.P4CmdOpts = this.P4CmdOpts + " -af";
        } else if (this.resolvemode.equals(SAFE)) {
            this.P4CmdOpts = this.P4CmdOpts + " -as";
        } else if (this.resolvemode.equals(THEIRS)) {
            this.P4CmdOpts = this.P4CmdOpts + " -at";
        } else if (this.resolvemode.equals(YOURS)) {
            this.P4CmdOpts = this.P4CmdOpts + " -ay";
        } else {
            throw new BuildException("unsupported or absent resolve mode");
        }
        if (this.P4View == null) {
            throw new BuildException("please specify a view");
        }
        if (this.isRedoall()) {
            this.P4CmdOpts = this.P4CmdOpts + " -f";
        }
        if (this.isSimulationmode()) {
            this.P4CmdOpts = this.P4CmdOpts + " -n";
        }
        if (this.isForcetextmode()) {
            this.P4CmdOpts = this.P4CmdOpts + " -t";
        }
        if (this.isMarkersforall()) {
            this.P4CmdOpts = this.P4CmdOpts + " -v";
        }
        this.execP4Command("-s resolve " + this.P4CmdOpts + " " + this.P4View, new SimpleP4OutputHandler(this));
    }
}

