/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;

public final class BatchTest
extends BaseTest {
    private Project project;
    private Resources resources = new Resources();

    public BatchTest(Project project) {
        this.project = project;
        this.resources.setCache(true);
    }

    public void addFileSet(FileSet fs) {
        this.add((ResourceCollection)fs);
        if (fs.getProject() == null) {
            fs.setProject(this.project);
        }
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public Enumeration elements() {
        Object[] tests = this.createAllJUnitTest();
        return Enumerations.fromArray(tests);
    }

    void addTestsTo(Vector v) {
        JUnitTest[] tests = this.createAllJUnitTest();
        v.ensureCapacity(v.size() + tests.length);
        for (int i = 0; i < tests.length; ++i) {
            v.addElement(tests[i]);
        }
    }

    private JUnitTest[] createAllJUnitTest() {
        String[] filenames = this.getFilenames();
        JUnitTest[] tests = new JUnitTest[filenames.length];
        for (int i = 0; i < tests.length; ++i) {
            String classname = BatchTest.javaToClass(filenames[i]);
            tests[i] = this.createJUnitTest(classname);
        }
        return tests;
    }

    private String[] getFilenames() {
        Vector<String> v = new Vector<String>();
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            Resource r = (Resource)iter.next();
            if (!r.isExists()) continue;
            String pathname = r.getName();
            if (pathname.endsWith(".java")) {
                v.addElement(pathname.substring(0, pathname.length() - ".java".length()));
                continue;
            }
            if (!pathname.endsWith(".class")) continue;
            v.addElement(pathname.substring(0, pathname.length() - ".class".length()));
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public static String javaToClass(String filename) {
        return filename.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.');
    }

    private JUnitTest createJUnitTest(String classname) {
        JUnitTest test = new JUnitTest();
        test.setName(classname);
        test.setHaltonerror(this.haltOnError);
        test.setHaltonfailure(this.haltOnFail);
        test.setFiltertrace(this.filtertrace);
        test.setFork(this.fork);
        test.setIf(this.getIfCondition());
        test.setUnless(this.getUnlessCondition());
        test.setTodir(this.destDir);
        test.setFailureProperty(this.failureProperty);
        test.setErrorProperty(this.errorProperty);
        Enumeration list = this.formatters.elements();
        while (list.hasMoreElements()) {
            test.addFormatter((FormatterElement)list.nextElement());
        }
        return test;
    }
}

