/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.property;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.property.NullReturn;

public class LocalPropertyStack {
    private LinkedList stack = new LinkedList();

    public void addLocal(String property) {
        if (!this.stack.isEmpty()) {
            ((Map)this.stack.getFirst()).put(property, NullReturn.NULL);
        }
    }

    public void enterScope() {
        this.stack.addFirst(new HashMap());
    }

    public void exitScope() {
        ((HashMap)this.stack.removeFirst()).clear();
    }

    public LocalPropertyStack copy() {
        LocalPropertyStack ret = new LocalPropertyStack();
        ret.stack.addAll(this.stack);
        return ret;
    }

    public Object evaluate(String property, PropertyHelper helper) {
        Iterator i = this.stack.iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next();
            Object ret = map.get(property);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean setNew(String property, Object value, PropertyHelper propertyHelper) {
        Map map = this.getMapForProperty(property);
        if (map == null) {
            return false;
        }
        Object currValue = map.get(property);
        if (currValue == NullReturn.NULL) {
            map.put(property, value);
        }
        return true;
    }

    public boolean set(String property, Object value, PropertyHelper propertyHelper) {
        Map map = this.getMapForProperty(property);
        if (map == null) {
            return false;
        }
        map.put(property, value);
        return true;
    }

    private Map getMapForProperty(String property) {
        Iterator i = this.stack.iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next();
            if (map.get(property) == null) continue;
            return map;
        }
        return null;
    }
}

