$(function(){

    $.fn.hasAttr = function(name) {  
       return this.attr(name) !== undefined;
    };

//open modal
    $(document).on('click', 'a.open-modal', function(e){
        e.preventDefault();
        var modalRemote = $(this).attr('href'),
            typeMedia = $(this).attr('data-type-media'),
            modalTitleInfo = $(this).attr('data-title'),
            hideBibliotheque = $(this).hasAttr('data-hide-bibliotheque') ? true : false,
            hideAddNew = $(this).hasAttr('data-hide-add-new') ? true : false,
            isIframe = $(this).hasAttr('data-iframe') ? true : false,
            titleFront;

        switch(typeMedia){
            case 'video' : titleFront = '<i class="icon-film"></i> Vidéo - '+modalTitleInfo; break;
            case 'image' : titleFront = '<i class="icon-picture"></i> Image - '+modalTitleInfo; break;
        }
        $('#modal-template .modal-header h3').html(titleFront);
        
        if(isIframe){
            if(hideBibliotheque)
                $("#modal-template").find(".bibliotheque-link").hide();
            if(hideAddNew)
                $("#modal-template").find(".add-new").hide();

            $("#modal-template .modal-body").html('<iframe src="' + modalRemote + '" seamless="seamless" width="580" height="440"></iframe>');
            $("#modal-template").modal("show");
        }
        else{
            $("#modal-template .modal-body").load(modalRemote, function() { 
                $("#modal-template").modal("show"); 
                if(hideBibliotheque)
                    $("#modal-template").find(".bibliotheque-link").hide();
                if(hideAddNew)
                    $("#modal-template").find(".add-new").hide();
            });
        }
    });

    $('.popup').on('click', '.popup-content a', function(e){
        
        if($(this).hasClass('no-prevent')){
            return true;
        }else{
            e.preventDefault();
        }
        if($(this).hasClass('btn-cancel')){
            $(this).parents('.popup').modal('hide');
        }

    });

// empty modal when closed
      $("#modal-template .modal-header .close").click(function(e){
          $("#modal-template .modal-body").html('');
      });

//confirmation suppression
    $(document).on('click','.btn-delete', function(e){
        e.preventDefault();
        var titleMedia = $(this).attr('data-title'),
            urlDelete = $(this).attr('href');
        $("#modal-confirm #btn-delete-modal").attr('href', urlDelete).focus();
        $("#modal-confirm .modal-body").find('.titleMedia').text(titleMedia);
        $("#modal-confirm").modal('show');
    });

    $("#modal-confirm").on('shown', function() {
        $("#modal-confirm #btn-delete-modal").focus();
    });
    
});