from django.conf.urls.defaults import patterns, url
from metadatacomposer.views import MetadataComposerHome, MetadataComposerProjectList,\
    MetadataComposerResourceList, MetadataComposerContentPagination,\
    MetadataComposerModalVideo, MetadataComposerModalImage,\
    MetadataComposerImagePagination

urlpatterns = patterns('',
    url(r'^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', name='jsi18n'),
    url(r'^(?P<branding>.*)/projectlist/$', MetadataComposerProjectList.as_view(), name="composer_project_list"),
    url(r'^(?P<branding>.*)/resourcelist/$', MetadataComposerResourceList.as_view(), name="composer_resource_list"),
    url(r'^(?P<branding>.*)/imagepage/$', MetadataComposerImagePagination.as_view(), name="composer_image_page"),
    url(r'^(?P<branding>.*)/contentpage/$', MetadataComposerContentPagination.as_view(), name="composer_content_page"),
    url(r'^(?P<branding>.*)/modalvideo/$', MetadataComposerModalVideo.as_view(), name="composer_modal_video"),
    url(r'^(?P<branding>.*)/modalimage/$', MetadataComposerModalImage.as_view(), name="composer_modal_image"),
    url(r'^(?P<branding>.*)/$', MetadataComposerHome.as_view(), name="composer_home"),
    url(r'^$', MetadataComposerHome.as_view(), name="composer_home"),
)
