from django.db import models
import os
import time


def image_file_name(instance, filename):
    now = time.time()
    milliseconds = '%03d' % int((now - int(now)) * 1000)
    localtime = time.localtime()
    _, ext = os.path.splitext(filename)
    filename = time.strftime('%Y%m%d%H%M%S', localtime) + milliseconds
    return 'metadatacomposer/images/' + filename + ext


class Image(models.Model):
    
    image_file = models.ImageField(width_field="width", height_field="height", upload_to=image_file_name, max_length=2048)
    width = models.IntegerField(null=False, blank=False)
    height = models.IntegerField(null=False, blank=False)
    title = models.CharField(null=True, blank=True, max_length=1024)
    description = models.TextField(null=True, blank=True)
    creation_date = models.DateTimeField(auto_now_add=True)
    modification_date = models.DateTimeField(auto_now=True)
    