$(function(){

    $.fn.hasAttr = function(name) {  
       return this.attr(name) !== undefined;
    };

//open modal
    $(document).on('click', 'a.open-modal', function(e){
        e.preventDefault();
        var modalRemote = $(this).attr('href'),
            typeMedia = $(this).attr('data-type-media'),
            modalTitleInfo = $(this).attr('data-title'),
            hideBibliotheque = $(this).hasAttr('data-hide-bibliotheque') ? true : false,
            titleFront;

        switch(typeMedia){
            case 'video' : titleFront = '<i class="icon-film"></i> Vidéo - '+modalTitleInfo; break;
            case 'image' : titleFront = '<i class="icon-picture"></i> Image - '+modalTitleInfo; break;
        }
        $('#modal-template .modal-header h3').html(titleFront);

        $("#modal-template .modal-body").load(modalRemote, function() { 
            $("#modal-template").modal("show"); 
            if(hideBibliotheque)
                $("#modal-template").find(".bibliotheque-link").hide();
        });

    });

    $('.popup').on('click', '.popup-content a', function(e){
        e.preventDefault();
        if($(this).hasClass('btn-cancel')){
            $(this).parents('.popup').modal('hide');
        }
        if($(this).hasClass('btn-previsualisation')){
            var imgPrev = $('<img src="img/520x520.gif" alt="" />');
            $('.previsualisation').empty().append(imgPrev);
        }
    });

//confirmation suppression
    $(document).on('click','.btn-delete', function(e){
        e.preventDefault();
        var titleMedia = $(this).attr('data-title'),
            urlDelete = $(this).attr('href');
        $("#modal-confirm #btn-delete-modal").attr('href', urlDelete).focus();
        $("#modal-confirm .modal-body").find('.titleMedia').text(titleMedia);
        $("#modal-confirm").modal('show');
    });

    $("#modal-confirm").on('shown', function() {
        $("#modal-confirm #btn-delete-modal").focus()
    });
    
    $("#modal-confirm").on('click', '#btn-delete-modal', function(e){

    });
    
});