/* Tangles */
    var tangleMsPerPixel = 100,
        activeTangle,
        tangleStartX,
        tangleStartVal,
        tangleHasMoved;
    
    $('.chapter-widget-info').on('mousedown', '.time-tangle', function(evt){
        activeTangle = $(this);
        activeTangle.addClass("active");
        tangleStartVal = +activeTangle.attr("data-milliseconds");
        tangleStartX = evt.pageX;
        tangleHasMoved = false;
        $(this).parents('td').siblings('td').find(".time-tangle").addClass("deactivate");
        return false;
    });

    $(document)
        .mousemove(function(evt) {
            if (activeTangle) {
                tangleHasMoved = true;
                var newval = new IriSP.Model.Time(tangleMsPerPixel * (evt.pageX - tangleStartX) + tangleStartVal);
                activeTangle.trigger("valuechange", newval);
                return false;
            }
        })
        .mouseup(function() {
            if (activeTangle) {
                $(".time-tangle").removeClass("active deactivate");
                activeTangle = undefined;
            }
        });

    function updateRenderChapter(chapterData){
        var segment = $('.chapter-segments li#'+chapterData.id),
            wChapterSegmentWrap = $('.chapter-segments').width(),
            wSegmentNew = chapterData.getDuration() * wChapterSegmentWrap / myMedia.duration,
            lSegmentNew = chapterData.begin * wChapterSegmentWrap / myMedia.duration,
            row = $('#row-list-chapter-'+chapterData.id),
            form = ($('#form-chapter-edit-'+chapterData.id).length) ? $('#form-chapter-edit-'+chapterData.id) : false;

        segment.css({
            width : wSegmentNew,
            left : lSegmentNew
        });

        row.find('.begin').text(chapterData.begin);
        row.find('.duration').text(chapterData.getDuration());
        row.find('.end').text(chapterData.end);

        if(form){
            form.find('.begin').text(chapterData.begin);
            form.find('.begin').attr('data-milliseconds',chapterData.begin);
            form.find('.duration').text(chapterData.getDuration());
            form.find('.end').text(chapterData.end);
            form.find('.end').attr('data-milliseconds',chapterData.end);
        }
    }

    function updateChapterDuration(val, chapterBefore, chapterAfter){
        if (val<=chapterAfter.end && val>=chapterBefore.begin) {
            chapterAfter.setBegin(val);
            chapterBefore.setEnd(val);

            updateRenderChapter(chapterAfter);
            updateRenderChapter(chapterBefore);
        }
    }

    $('.chapter-widget-info').on('valuechange', '.tangle-start', function(evt, val){
        var indexChapter = _.indexOf(chapters, currentChapter);
        if(indexChapter == 0 || chapters.length<=1) return;
        
        var chapterBefore = chapters[indexChapter-1],
            chapterAfter = currentChapter;

        updateChapterDuration(val, chapterBefore, chapterAfter);
    });

    $('.chapter-widget-info').on('valuechange', '.tangle-end', function(evt, val){
        var indexChapter = _.indexOf(chapters, currentChapter);
        if(indexChapter == chapters.length-1 || chapters.length<=1) return;
        
        var chapterAfter = chapters[indexChapter+1],
            chapterBefore = currentChapter;
        
        updateChapterDuration(val, chapterBefore, chapterAfter);
    });
    /*
    $(".tangle-start")
        .mouseup(function(evt) {

            if (!tangleHasMoved && currentMedia && currentSegment) {
                currentMedia.setCurrentTime(currentSegment.begin);
            }
        })
        .on("valuechange", function(evt, val) {

            if (currentMedia && currentSegment) {
                currentSegment.setBegin(val);
            }
        });

    $(".tangle-end")
        .mouseup(function(evt) {
            if (!tangleHasMoved && currentMedia && currentSegment) {
                currentMedia.setCurrentTime(currentSegment.end);
            }
        })
        .on("valuechange", function(evt, val) {
            if (currentMedia && currentSegment) {
                currentSegment.setEnd(val);
            }
        });
    $(".tangle-duration").on("valuechange", function(evt, val) {
        if (currentMedia && currentSegment) {
            currentSegment.setDuration(val);
        }
       
    }); */