from django.conf.urls.defaults import patterns, url
from metadatacomposer.views import MetadataComposerHome, MetadataComposerProjectList,\
    MetadataComposerResourceList, MetadataComposerContentPagination,\
    MetadataComposerModalContent, MetadataComposerModalImage,\
    MetadataComposerImagePagination, MetadataComposerModalImageLibrary,\
    MetadataComposerRemoveImage, MetadataComposerRemoveContent,\
    MetadataComposerRemoveProject, MetadataComposerImage,\
    MetadataComposerModalContentLibrary, MetadataComposerPlayer

urlpatterns = patterns('',
    url(r'^jsi18n/(?P<packages>\S+?)/$', 'django.views.i18n.javascript_catalog', name='jsi18n'),
    url(r'^(?P<branding>.*)/projectlist/$', MetadataComposerProjectList.as_view(), name="composer_project_list"),
    url(r'^(?P<branding>.*)/resourcelist/$', MetadataComposerResourceList.as_view(), name="composer_resource_list"),
    url(r'^(?P<branding>.*)/imagepage/$', MetadataComposerImagePagination.as_view(), name="composer_image_page"),
    url(r'^(?P<branding>.*)/contentpage/$', MetadataComposerContentPagination.as_view(), name="composer_content_page"),
    url(r'^(?P<branding>.*)/modalcontent/(?P<iri_id>[\w-]+)/$', MetadataComposerModalContent.as_view(), name="composer_modal_content"),
    url(r'^(?P<branding>.*)/modalcontent/$', MetadataComposerModalContent.as_view(), name="composer_modal_content"),
    url(r'^(?P<branding>.*)/modalcontentlibrary/$', MetadataComposerModalContentLibrary.as_view(), name="composer_modal_content_library"),
    url(r'^(?P<branding>.*)/modalimage/$', MetadataComposerModalImage.as_view(), name="composer_modal_image"),
    url(r'^(?P<branding>.*)/modalimagelibrary/$', MetadataComposerModalImageLibrary.as_view(), name="composer_modal_image_library"),
    url(r'^(?P<branding>.*)/removecontent/$', MetadataComposerRemoveContent.as_view(), name="composer_remove_content"),
    url(r'^(?P<branding>.*)/removeimage/$', MetadataComposerRemoveImage.as_view(), name="composer_remove_image"),
    url(r'^(?P<branding>.*)/removeproject/$', MetadataComposerRemoveProject.as_view(), name="composer_remove_project"),
    url(r'^(?P<branding>.*)/image/(?P<image_pk>[\w-]+)/$', MetadataComposerImage.as_view(), name="composer_image"),
    url(r'^(?P<branding>.*)/player/(?P<ldt_id>[\w-]+)/$', MetadataComposerPlayer.as_view(), name="composer_player"),
    url(r'^(?P<branding>.*)/$', MetadataComposerHome.as_view(), name="composer_home"),
    url(r'^$', MetadataComposerHome.as_view(), name="composer_home"),
)
