$(function(){

    $.fn.hasAttr = function(name) {  
       return this.attr(name) !== undefined;
    };

//open modal
    $(document).on('click', 'a.open-modal', function(e){
        e.preventDefault();
        var modalRemote = $(this).attr('href'),
            typeMedia = $(this).attr('data-type-media'),
            modalTitleInfo = $(this).attr('data-title'),
            hideBibliotheque = $(this).hasAttr('data-hide-bibliotheque') ? true : false,
            titleFront;

        switch(typeMedia){
            case 'video' : titleFront = '<i class="icon-film"></i> Vidéo - '+modalTitleInfo; break;
            case 'image' : titleFront = '<i class="icon-picture"></i> Image - '+modalTitleInfo; break;
        }
        $('#modal-template .modal-header h3').html(titleFront);

        $("#modal-template .modal-body").load(modalRemote, function() { 
            $("#modal-template").modal("show"); 
            if(hideBibliotheque)
                $("#modal-template").find(".bibliotheque-link").hide();
        });

    });

    $('.popup').on('click', '.popup-content a', function(e){
        e.preventDefault();
        if($(this).hasClass('btn-cancel')){
            $(this).parents('.popup').modal('hide');
        }
        if($(this).hasClass('btn-previsualisation')){
            var imgPrev = $('<img src="img/520x520.gif" alt="" />');
            $('.previsualisation').empty().append(imgPrev);
        }
    });

//confirmation suppression
    $(document).on('click','.btn-delete', function(e){
        e.preventDefault();
        var titleMedia = $(this).attr('data-title'),
            textModal = $('<p>Êtes-vous sûr de vouloir supprimer <strong>'+titleMedia+'</strong> ?</p>'),
            eltDelete = $(this).attr('href');
        $("#modal-confirm #btn-delete-modal").attr('data-id-elt-delete', eltDelete);
        $("#modal-confirm .modal-body").empty().append(textModal); 
        $("#modal-confirm").modal('show');
    });

    $("#modal-confirm").on('click', '#btn-delete-modal', function(e){
        e.preventDefault();
        var idEltDelete = $(this).attr('data-id-elt-delete');
        $(idEltDelete).remove();
        $("#modal-confirm").modal('hide');
    });
    
});