from django.conf import settings
from django.contrib.auth.models import User
from django.contrib.auth.decorators import login_required
from django.core.exceptions import ObjectDoesNotExist
from django.core.paginator import Paginator, InvalidPage, EmptyPage
from django.http import HttpResponseNotFound, HttpResponse
from django.shortcuts import redirect
from django.utils.decorators import method_decorator
from django.views.generic.base import View, TemplateResponseMixin
from ldt.ldt_utils.models import Project, Content
#import logging
#import re

class MashupContextView(View):
    
    branding = "iri"
    
    def get_context_dict(self, request):
        context = {}
        context["branding"] = self.branding
        context["top_header_partial"] = "partial/%s_composer_header.html" % self.branding
        return context
            

class MetadataComposerHome(TemplateResponseMixin, MashupContextView):
    
    def get_template_names(self):
        return "metadatacomposer_home.html"
    
    @method_decorator(login_required)
    def dispatch(self, *args, **kwargs):
        return super(MetadataComposerHome, self).dispatch(*args, **kwargs)
    
    def get(self, request, branding="iri", **kwargs):
        self.branding = branding
        
        projects = Project.safe_objects.filter(owner=request.user).order_by('-modification_date')[:6]
        contents = Content.safe_objects.order_by('-update_date')[:6]
        
        context = self.get_context_dict(request)
        context.update({"projects":projects, "contents": contents})
        return self.render_to_response(context)
    
    