#encoding:UTF-8

""" Run these tests with 'python manage.py test text'  """

from django.conf import settings
from django.contrib.auth.models import *
from django.test import TestCase
from ldt.core.models import Owner
from ldt.test.testcases import OAuthWebTestCase
from ldt.text import VERSION_STR
from ldt.text.models import *
from ldt.text.views import *
from oauth_provider.models import Resource, Consumer, Token, Nonce
import datetime
import logging
import lxml.etree
import tempfile
import time
import unittest
import urllib
import uuid

class OnServerGlobalTest(OAuthWebTestCase):
    
    fixtures = ['test_data']
    
    def setUp(self):
        
        self.id = "mypersonnalid"
        self.id2 = "mypersonnalid2"

        self.CONSUMER_KEY = 'dpf43f3p2l4k3l03'
        self.CONSUMER_SECRET = 'kd94hf93k423kf44'
        
        self.set_consumer(self.CONSUMER_KEY, self.CONSUMER_SECRET)
        
        self.set_login_url("/accounts/login/")                
        
        
    def test_everything(self):
        
        res = self.client.login(username='jane', password='toto')
        res = self.assertTrue(res)

        creation = self.client.post("/api/"+VERSION_STR+"/text/create/", data={'content':'<iri><text-annotation><id>'+self.id+'</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#AAAAAA</color><description><![CDATA[texte de description]]></description><title><![CDATA[titre de l\'annotation]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'})            
        logging.debug("OnServerGlobalTest.test_everything creation : "  + repr(creation.content))

        creation2 = self.client.post("/api/"+VERSION_STR+"/text/create/", data={'content':'<iri><text-annotation><id>'+self.id2+'</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#BBBBBB</color><description><![CDATA[texte de description2]]></description><title><![CDATA[titre de l\'annotation2]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation2]]></text></content><meta><contributor>wakimd</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'})
        logging.debug("OnServerGlobalTest.test_everything creation2 : "  + repr(creation2.content))
        
        get = self.client.get("/api/"+VERSION_STR+"/text/get/", {"id":self.id})
        logging.debug("OnServerGlobalTest.test_everything get : "  + repr(get.content))
          
        update = self.client.post("/api/"+VERSION_STR+"/text/update/", data={'content':'<iri><text-annotation><id></id><uri></uri><tags><tag>tag1</tag><tag>tag2new</tag><tag>tag3</tag></tags><content><color>#DDDDDD</color><description><![CDATA[texte de description update]]></description><title></title><text><![CDATA[texte selectionne a nouveau lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>80cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created></created><creator></creator><creator-id></creator-id><modified>2010-11-06 12:33:53.420459</modified></meta></text-annotation></iri>','id':self.id})
        logging.debug("OnServerGlobalTest.test_everything update : "  + repr(update.content))
        
        filt1 = self.client.get("/api/"+VERSION_STR+"/text/filter/", data={"uri":"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168"})
        logging.debug("OnServerGlobalTest.test_everything filt1 : "  + repr(filt1.content))

        filt2 = self.client.get("/api/"+VERSION_STR+"/text/filter/", data={"uri":"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168","creator":"wakimd"})
        
        logging.debug("OnServerGlobalTest.test_everything filt2 : "  +repr(filt2.content))
        
        delete = self.client.post("/api/"+VERSION_STR+"/text/delete/", {"id":self.id})
        logging.debug("OnServerGlobalTest.test_everything delete1 : "  + repr(delete.content))
        delete = self.client.post("/api/"+VERSION_STR+"/text/delete/", {"id":self.id2})
        logging.debug("OnServerGlobalTest.test_everything delete2 : "  + repr(delete.content))
        
