"""
Some useful form widgets
"""

from django.contrib.admin.widgets import AdminSplitDateTime
from django.utils.safestring import mark_safe
from django.utils.translation import ugettext as _


class LdtSplitDateTime(AdminSplitDateTime):
    """
    A widget that extend the AdminSplitDateTime to improve the html outputted
    """
    
    def format_output(self, rendered_widgets):
        return mark_safe(u'<div class="ldtdatetime"><div class="ldtdate"><div class="ldtdatetitle">%s</div> <div class="ldtdatefield">%s</div></div><div class="ldttime"><div class="ldttimetitle">%s</div> <div class="ldttimefield">%s</div></div></div>' % \
            (_('Date'), rendered_widgets[0],  _('Time'), rendered_widgets[1]))
