from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _
from ldt.core.models import Document, Owner
from django.contrib.auth.models import User
import tagging.fields
from utils import generate_uuid
import lxml.etree
import os.path
import uuid
import lucene
from ldt.ldt_utils import STORE, ANALYZER
#from django.core.management.validation import max_length



class Annotation(models.Model):
    id = models.CharField(max_length=1024, primary_key=True, unique=True, default=generate_uuid, verbose_name=_('annotation.id'))
    uri = models.CharField(max_length=1024, verbose_name=_('annotation.uri'))
    tags = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('annotation.tags'))
    title = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('annotation.title'))
    description = models.TextField(null=True, blank=True, verbose_name=_('annotation.description'))
    text = models.TextField(null=True, blank=True, verbose_name=_('annotation.text'))
    color = models.CharField(max_length=1024, verbose_name=_('annotation.color'))
    creator = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('creator.title'))
    contributor = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('contributor.title'))
    creation_date = models.DateTimeField(auto_now_add=True, verbose_name=_('annotation.creation_date'))
    update_date = models.DateTimeField(auto_now=True, verbose_name=_('annotation.update_date'))


    def __unicode__(self):
        return unicode(self.id) + u": " + unicode(self.title)

    @staticmethod
    def create_annotation(id, uri=None, tags=None, title=None, description=None, text=None, color=None, creator=None, contributor=None, creation_date=None, update_date=None):
        annotation = Annotation(id=id, uri=uri, tags=tags, title=title, description=description, text=text, color=color, creator=creator, contributor=contributor, creation_date=creation_date, update_date=update_date)
        annotation.save()
        
        return annotation
    

#class Author(models.Model):
#
#    handle = models.CharField(max_length=512, unique=True, blank=True, null=True)
#    email = models.EmailField(unique=False, blank=True, null=True)
#    firstname = models.CharField(max_length=512, blank=True, null=True)
#    lastname = models.CharField(max_length=512, blank=True, null=True)
#    
#    def __unicode__(self):
#        return unicode(self.id) + " - " + self.handle + ", " + self.email + ", " + self.firstname + " " + self.lastname

