#encoding:UTF-8

""" Run these tests with 'python manage.py test text'  """

from django.test import TestCase
import unittest
import lxml.etree
from ldt.text.models import *
from ldt.core.models import Owner
from views import *
import urllib
import uuid
import tempfile
import datetime
from django.contrib.auth.models import *
from django.conf import settings
from django.test.client import Client
from ldt.text import VERSION_STR
from django.db import transaction


# This test creates an annotation and checks that:
# 1. the annotation was created in the database (by trying to access it through a 'get')
# 2. the returned xml contains correct data
class CreateTest(unittest.TestCase):
    def setUp(self):
        self.content = str('<iri><text-annotation><id>f2c1d1fa-629d-4520-a3d2-955b4f2582c0</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#AAAAAA</color><description><![CDATA[texte de description]]></description><title><![CDATA[titre de l\'annotation]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>')
        self.c = Client()
        self.annot = Annotation(external_id=u'd2c1d1fa-629d-4520-a3d2-955b4f2582c0', uri=u'http://iri.blabla', tags=u"tag1,tag2", title=u'montitre', description=u'madesc', text=u'letexteselectionne', color=u'#AAAAAA', creator=u'wakimd', contributor=u'wakimd', creation_date=u'2010-09-06 12:33:53.417550', update_date=u'2010-09-06 12:33:53.417550')
        self.annot.save()
    def tearDown(self):
        transaction.rollback()
        annotlist=Annotation.objects.all()
        for annot in annotlist:
            annot.delete()

    def test_create_annotation(self):
        response = self.c.post('/api/'+ VERSION_STR +'/text/create/', {'content':self.content})
        #self.assertEqual(response.content, "  ")
        self.annot1 = lxml.etree.fromstring(response.content)
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/id/text()")[0],"f2c1d1fa-629d-4520-a3d2-955b4f2582c0")
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/content")[0].tag,"content")
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/tags/tag/text()")[0],u"tag1")
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/content/text/text()")[0],u"texte selectionne lors de la creation de l\'annotation")
        #self.assertEqual(self.annot1.xpath("/iri/text-annotation/meta/created/text()")[0],"2010-09-06 12:33:53.417550")
        response2 = self.c.get('/api/'+ VERSION_STR +'/text/get/', {'id':'f2c1d1fa-629d-4520-a3d2-955b4f2582c0'})
        annot2 = lxml.etree.fromstring(response.content)
        self.assertEqual(annot2.xpath("/iri/text-annotation/uri/text()")[0], "http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168")
        
    def test_error_create(self):
        content = '<iri><text-annotation><id>d2c1d1fa-629d-4520-a3d2-955b4f2582c0</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#AAAAAA</color><description><![CDATA[texte de description]]></description><title><![CDATA[titre de l\'annotation]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'
        response = self.c.post('/api/'+ VERSION_STR +'/text/create/', {'content':content})
        self.assertEqual(response.status_code, 409)


# This test creates an annotation, then gets it, and checks that the returned xml contains correct data
class GetTest(unittest.TestCase):
    def setUp(self):
        self.annotation = Annotation(external_id="d2c1d1fa-629d-4520-a3d2-955b4f2582c0", tags=u"tag1 ,tag2 ,     tag3", title="titre de l\'annotation",text="texte selectionne lors de la creation de l\'annotation",color="#AAAAAA", creation_date="2010-09-06 12:33:53.417550", update_date="2010-09-06 12:33:53.420459")
        self.annotation.save()
        self.c = Client()
    def tearDown(self):
        annotlist=Annotation.objects.all()
        for annot in annotlist:
            annot.delete()
      
    def test_get_annotation(self):
        response = self.c.get('/api/'+ VERSION_STR +'/text/get/', {'id':'d2c1d1fa-629d-4520-a3d2-955b4f2582c0'})
        print response
        self.annot1 = lxml.etree.fromstring(response.content)
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/id/text()")[0],self.annotation.external_id)
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/tags/tag/text()")[1], "tag2")
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/content/color/text()")[0],self.annotation.color)
        self.assertEqual(self.annot1.xpath("/iri/text-annotation/meta/created/text()")[0], str(self.annotation.creation_date))

    def test_error_get(self):
        response = self.c.get('/api/'+ VERSION_STR +'/text/get/', {'id':'2'})
        self.assertEqual(response.status_code,404)
        
        
class FilterTest(unittest.TestCase):
    def setUp(self):
        self.annotation = Annotation(external_id="k2c1d1fa-629d-4520-a3d2-955b4f2582c0",title="titre de l\'annotation",text="texte selectionne lors de la creation de l\'annotation",color="#AAAAAA", uri="http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168", creator="wakimd")
        self.annotation.save()
        self.annotation2 = Annotation(external_id="l2c1d1fa-629d-4520-a3d2-955b4f2582c0",title="titre de l\'annotation2",text="texte selectionne lors de la creation de l\'annotation2",color="#BBBBBB", uri="http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168", creator="wakimd")
        self.annotation2.save()
        self.annotation3 = Annotation(external_id="m2c1d1fa-629d-4520-a3d2-955b4f2582c0", title="titre3", text="texte3", color="#CCCCCC", uri="http://blabla", creator="wakimd")
        self.annotation3.save() 
        self.c = Client()       
    def tearDown(self):
        annotlist=Annotation.objects.all()
        for annot in annotlist:
            annot.delete()
        
    def test_filter_annotation_creator_limit(self):
        user = 'wakimd'
        uri = "http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168"
        limit= 1
        response = self.c.get('/api/'+ VERSION_STR +'/text/filter/', {'uri':uri,'creator':user,'limit':limit})
        doc = lxml.etree.fromstring(response.content)
        cpt = 0
        for elem in doc.xpath("/iri/text-annotation"):
            cpt = cpt + 1
        if limit is not None:
            self.assertEqual(cpt,limit)
        for elem in doc.xpath("/iri/text-annotation/meta/creator/text()"):
            self.assertEqual(elem,user)
        for elem in doc.xpath("/iri/text-annotation/uri/text()"):
            self.assertEqual(elem[:57],"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml")
        
    def test_filter_annotation_uri(self):
        uri = "http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168"
        response = self.c.get('/api/'+ VERSION_STR +'/text/filter/', {'uri':uri})
        doc = lxml.etree.fromstring(response.content)
        for elem in doc.xpath("/iri/text-annotation/uri/text()"):
            self.assertEqual(elem[:57],"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml")
            
    def test_filter_annotation_filter(self):
        uri = "http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168"
        filter = 'lors'
        limit = None
        response = self.c.get('/api/'+ VERSION_STR +'/text/filter/', {'uri':uri,'filter':'lors'})
        doc = lxml.etree.fromstring(response.content)
        for elem in doc.xpath("/iri/text-annotation/content/text/text()"):
            self.assertTrue('lors' in elem)  
        #for elem in doc.xpath("/iri/text-annotation/meta/creator/text()"):
        #    self.assertEqual(elem,user)          


# This test creates an annotation, then deletes it, and checks that:
# 1. the annotation doesn't exist anymore in the database (by trying to access it through a 'get')
# 2. the returned xml contains no data
class DeleteTest(unittest.TestCase):
    def setUp(self):
        self.annotation = Annotation(external_id="d2c1d1fa-629d-4520-a3d2-955b4f2582c0",title="titre de l\'annotation",text="texte selectionne lors de la creation de l\'annotation",color="#AAAAAA", creation_date="2010-09-06T12:33:53.417550", update_date="2010-09-06T12:33:53.420459")
        self.annotation.save()
        self.c = Client()    
    def tearDown(self):
        annotlist=Annotation.objects.all()
        for annot in annotlist:
            annot.delete()
    
    def test_delete_annotation(self):
        id = urllib.urlencode({'id':'d2c1d1fa-629d-4520-a3d2-955b4f2582c0'})
        f = urllib.urlopen("http://127.0.0.1:8000/api/1.0/text/delete/", id)
        response = self.c.post('/api/'+ VERSION_STR +'/text/delete/', {'id':'d2c1d1fa-629d-4520-a3d2-955b4f2582c0'})
        response2 = self.c.get('/ldt/get/', {'id':'d2c1d1fa-629d-4520-a3d2-955b4f2582c0'})
        doc = lxml.etree.fromstring(response.content)
        self.assertEqual(doc.xpath("/iri/text-annotation/id/text()"),[])
        self.assertEqual(doc.xpath("/iri/text-annotation/tags/tag/text()"), [])
        self.assertEqual(doc.xpath("/iri/text-annotation/content/color/text()"),[])
        self.assertEqual(doc.xpath("/iri/text-annotation/meta/creator/text()"),[])
        self.assertEqual(response2.status_code, 404)   

    def test_error_delete(self):
        response = self.c.post('/api/'+ VERSION_STR +'/text/ldt/delete/', {'id':'1'})
        self.assertEqual(response.status_code,404)
        

# This test creates an annotation, then updates it with new content, and checks that the returned xml contains the updated data
class UpdateTest(unittest.TestCase):
    def setUp(self):
        self.annotation = Annotation(external_id="d2c1d1fa-629d-4520-a3d2-955b4f2582c0", tags=u"tag1, mytag",title="titre de l\'annotation",text="texte selectionne lors de la creation de l\'annotation",color="#AAAAAA", creation_date="2010-09-06T12:33:53.417550", update_date="2010-09-06T12:33:53.420459")
        self.annotation.save()
        self.c = Client()
    def tearDown(self):
        annotlist=Annotation.objects.all()
        for annot in annotlist:
            annot.delete()
            
    def test_update_annotation(self):
        content = '<iri><text-annotation><id></id><uri></uri><tags><tag>tag1</tag><tag>tag2new</tag><tag>tag3</tag></tags><content><color>#DDDDDD</color><description><![CDATA[texte de description update]]></description><title></title><text><![CDATA[texte selectionne a nouveau lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>80cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created></created><creator></creator><creator-id></creator-id><modified>2010-11-06 12:33:53.420459</modified></meta></text-annotation></iri>'
        response = self.c.post('/api/'+ VERSION_STR +'/text/update/', {'content':content,'id':'d2c1d1fa-629d-4520-a3d2-955b4f2582c0'})        
        doc = lxml.etree.fromstring(response.content)
        #self.assertEqual(lxml.etree.tostring(doc), " ")
        self.assertEqual(doc.xpath("/iri/text-annotation/id/text()")[0],"d2c1d1fa-629d-4520-a3d2-955b4f2582c0")
        self.assertEqual(doc.xpath("/iri/text-annotation/tags/tag/text()")[1], "tag2new")
        self.assertEqual(doc.xpath("/iri/text-annotation/content/color/text()")[0],"#DDDDDD")
        
    def test_error_update(self):
        content = '<iri><text-annotation><id>d2c1d1fa-629d-4520-a3d2-955b4f2582c0</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#AAAAAA</color><description><![CDATA[texte de description]]></description><title><![CDATA[titre de l\'annotation]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'
        response = self.c.post('/api/'+ VERSION_STR +'/text/update/', {'content':content,'id':'1'})
        self.assertEqual(response.status_code,404)
               

class OnServerGlobalTest(unittest.TestCase):
    def setUp(self):
        self.content = urllib.urlencode({'content':'<iri><text-annotation><id>mypersonnalid</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#AAAAAA</color><description><![CDATA[texte de description]]></description><title><![CDATA[titre de l\'annotation]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'})
        self.content2 = urllib.urlencode({'content':'<iri><text-annotation><id>mypersonnalid2</id><uri>http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168</uri><tags><tag>tag1</tag><tag>tag2</tag></tags><content><color>#BBBBBB</color><description><![CDATA[texte de description2]]></description><title><![CDATA[titre de l\'annotation2]]></title><text><![CDATA[texte selectionne lors de la creation de l\'annotation2]]></text></content><meta><contributor>wakimd</contributor><contributor-id>79cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created>2010-09-06 12:33:53.417550</created><creator>oaubert</creator><creator-id>79cd0532-1dda-4130-b351-6a181130a7c9</creator-id><modified>2010-09-06 12:33:53.420459</modified></meta></text-annotation></iri>'})
        self.id = urllib.urlencode({"id":"mypersonnalid"})
        self.id2 = urllib.urlencode({"id":"mypersonnalid2"})
        self.uri = urllib.urlencode({"uri":"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168"})
        self.filt1 = urllib.urlencode({"uri":"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168", "creator":"","limit":"","filter":""})
        self.filt2 = urllib.urlencode({"uri":"http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168","creator":"wakimd","limit":"","filter":""})
        self.up = urllib.urlencode({'content':'<iri><text-annotation><id></id><uri></uri><tags><tag>tag1</tag><tag>tag2new</tag><tag>tag3</tag></tags><content><color>#DDDDDD</color><description><![CDATA[texte de description update]]></description><title></title><text><![CDATA[texte selectionne a nouveau lors de la creation de l\'annotation]]></text></content><meta><contributor>oaubert</contributor><contributor-id>80cd0532-1dda-4130-b351-6a181130a7c9</contributor-id><created></created><creator></creator><creator-id></creator-id><modified>2010-11-06 12:33:53.420459</modified></meta></text-annotation></iri>','id':'mypersonnalid'})
    
    def test_everything(self):
        creation = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/create/", self.content)
        creation2 = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/create/", self.content2)
        
        get = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/get/?%s" % self.id)
        
        update = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/update/", self.up)
        
        filt1 = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/filter/?%s", self.uri)
        filt2 = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/filter/?uri=http://www.leezam.com/pub/epub/123456!/OPS/chapter2.xhtml#pos=56,168?creator=wakimd")
        tmp = open('debug.html','r+')
        tmp.write(filt2.read())
        
        delete = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/delete/", self.id)
        delete = urllib.urlopen("http://127.0.0.1:8000/api/"+VERSION_STR+"/text/delete/", self.id2)
        
        