from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _
from ldt.core.models import Document, Owner
from django.contrib.auth.models import User
import tagging.fields
from utils import generate_uuid
import os.path
import uuid
#from django.core.management.validation import max_length


class Annotation(models.Model):
    external_id = models.CharField(max_length=1024, null=False, unique=True, default=generate_uuid, verbose_name=_('annotation.external_id'))
    uri = models.CharField(max_length=1024, verbose_name=_('annotation.uri'))
    tags = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('annotation.tags'))
    title = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('annotation.title'))
    description = models.TextField(null=True, blank=True, verbose_name=_('annotation.description'))
    text = models.TextField(null=True, blank=True, verbose_name=_('annotation.text'))
    color = models.CharField(max_length=1024, verbose_name=_('annotation.color'))
    creator = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('creator.title'))
    contributor = models.CharField(max_length=1024, null=True, blank=True, verbose_name=_('contributor.title'))
    creation_date = models.DateTimeField(auto_now_add=True, verbose_name=_('annotation.creation_date'))
    update_date = models.DateTimeField(auto_now=True, verbose_name=_('annotation.update_date'))


    def __unicode__(self):
        return unicode(self.external_id) + u": " + unicode(self.title)

    @staticmethod
    def create_annotation(external_id, uri=None, tags=None, title=None, description=None, text=None, color=None, creator=None, contributor=None, creation_date=None, update_date=None):
        annotation = Annotation(external_id=external_id, uri=uri, tags=tags, title=title, description=description, text=text, color=color, creator=creator, contributor=contributor, creation_date=creation_date, update_date=update_date)
        annotation.save()
        
        return annotation
    

