#!/usr/bin/env python

import requests
from lxml import etree
import sys
import zipfile
import re
import slugify


project_id = sys.argv[1]

dlurl = "http://ldt.iri.centrepompidou.fr/ldtplatform/ldt/space/ldt/project/" + project_id

r = requests.get(dlurl)

ldt_root = etree.fromstring(r.content)

project_title = ldt_root.find("project").get("title")

#create zipfile
if project_title:
    basename = slugify.slugify(project_title)
else:
    basename = project_id
zf = zipfile.ZipFile(basename+".zip", "w")
try:
    for i,media_node in enumerate(ldt_root.iterfind("medias/media")):
        iri_url = media_node.get("src")
        r_iri = requests.get(iri_url)
        iriname = "iri/%s_%d.iri" % (basename, i)
        zf.writestr(basename+"/"+iriname, r_iri.content)
        media_node.set("src", iriname)
        media_node.set("video", "")
    zf.writestr(basename+'/'+basename+".ldt", etree.tostring(ldt_root, xml_declaration=True, encoding='utf-8'))
finally:
    zf.close()
