# set base image (host OS)
FROM docker.io/python:2.7-alpine as builder

ENV VIRTUALENV=/opt/venv

# set the working directory in the container
WORKDIR /code

RUN \
    pip install virtualenv && \
    virtualenv $VIRTUALENV

ENV PATH="$VIRTUALENV/bin:$PATH"

# copy the dependencies file to the working directory
COPY docker/server/requirements.txt .


RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt && \
 apk add --no-cache --virtual .build-deps gcc musl-dev postgresql-dev libxml2-dev libxslt-dev linux-headers && \
 pip install -r requirements.txt

COPY hashcut ./hashcut
COPY metadatacomposer ./metadatacomposer
COPY platform ./platform

RUN \
  cd /code/platform/src/ldt && python setup.py sdist && pip install --no-binary ":all:" dist/*.tar.gz && \
  cd /code/hashcut/src && python setup.py sdist && pip install --no-binary ":all:" dist/*.tar.gz && \
  cd /code/metadatacomposer/src && python setup.py sdist && pip install --no-binary ":all:" dist/*.tar.gz


FROM docker.io/python:2.7-alpine 

COPY --from=builder /opt/venv /opt/venv

WORKDIR /code

ENV PATH="/opt/venv/bin:/code:$PATH"

RUN \
 apk add --no-cache postgresql-client postgresql-libs libxml2 libxslt bash && \
 mkdir -p /static /iridata/www/ldt/web/static/media /run/log 

COPY platform_web/src ./platform_web
COPY docker/server/config.py ./platform_web/ldtplatform/

COPY docker/server/platform.yml .
COPY --chmod=0755 docker/server/entrypoint.sh .

ENV PYTHONPATH "/code/platform_web"
ENV DJANGO_SETTINGS_MODULE ldtplatform.settings
ENV DEBUG "False"
ENV DATABASE_URL ""
ENV ES_HOST "es"
ENV LDT_SECRET ""

EXPOSE 8000

ENTRYPOINT ["entrypoint.sh"]

# command to run on container start
CMD [ "/opt/venv/bin/uwsgi", "--yaml", "/code/platform.yml"]