# -*- coding: utf-8 -*-
import os, logging

from environs import Env

env = Env()
# Read .env into os.environ
env.read_env()

SITE_ID = 1

BASE_DIR = "/iridata/www/ldt/src/ldtplatform/"
BASE_URL = "/"
PLATFORM_BASE_URL = BASE_URL + "ldtplatform/"
WEB_URL = "https://ldt.iri.centrepompidou.fr/"
WEB_AUTH = []
STATIC_URL = BASE_URL + "static/site/"


STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/"

STREAM_SRC_PREFIX = ""

BASE_STATIC_ROOT = "/static/"
BASE_STATIC_URL = BASE_URL + "static/"

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = "/iridata/www/ldt/web/static/media/"


# Absolute path to the directory that static files (js, css, swf...)
# DO NOT forget to do command line ./manage.py collectstatic to gather static media into the web/static folder
STATIC_ROOT = BASE_STATIC_ROOT + "site/"

# Make this unique, and don't share it with anybody.
SECRET_KEY = env.str("LDT_SECRET")

# PATH to the ffmpeg executable, used to know automatically the media file duration
FFMPEG_PATH = "/usr/bin/ffmpeg"


CONTENT_ROOT = BASE_STATIC_ROOT + "content/"

# PATH where uploaded media are put.
STREAM_PATH = CONTENT_ROOT

ADMIN_MEDIA_PREFIX = STATIC_URL + "admin/"
LDT_MEDIA_PREFIX = STATIC_URL + "ldt/"


DATABASES = {
    "default": env.dj_db_url("DATABASE_URL")
}

CACHES = {
    "default": {
        "BACKEND": "django.core.cache.backends.memcached.MemcachedCache",
        "LOCATION": "cache:11211",
        "KEY_PREFIX": "ldt",
    }
}

DEBUG = env.bool("DEBUG", default=False)
TEMPLATE_DEBUG = DEBUG

LOG_LEVEL = logging.INFO

LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        "simple": {
            "format": "%(asctime)s - %(levelname)s : %(message)s",
        },
        "semi-verbose": {"format": "%(levelname)s %(asctime)s %(module)s %(message)s"},
    },
    "filters": {"require_debug_false": {"()": "django.utils.log.RequireDebugFalse"}},
    "handlers": {
        "stream_to_console": {"level": LOG_LEVEL, "class": "logging.StreamHandler"},
    },
    "loggers": {
        #        'django.db.backends':{
        #            'handlers': ['file'],
        #            'level': LOG_LEVEL,
        #            'propagate': True,
        #        },
        #        'django.request': {
        #            'handlers': ['file'],
        #            'level': LOG_LEVEL,
        #            'propagate': True,
        #        },
        "ldt": {
            "handlers": ["stream_to_console"],
            "level": LOG_LEVEL,
            "propagate": True,
        },
        "ldt_utils": {
            "handlers": ["stream_to_console"],
            "level": LOG_LEVEL,
            "propagate": True,
        },
        "api": {
            "handlers": ["stream_to_console"],
            "level": LOG_LEVEL,
            "propagate": True,
        },
        "tastypie": {
            "handlers": ["stream_to_console"],
            "level": LOG_LEVEL,
            "propagate": True,
        },
    },
}


ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

GOOGLE_ANALYTICS_CODE = None

# EMAIL_USE_TLS = True
# EMAIL_HOST = 'smtp.gmail.com'
# EMAIL_HOST_USER = 'iri.ddc@gmail.com'
# EMAIL_HOST_PASSWORD = 'ddciripompidou'
# EMAIL_PORT = 587
DEFAULT_FROM_EMAIL = "root@iri.centrepompidou.fr"

ACCOUNT_ACTIVATION_DAYS = 7
REGISTRATION_OPEN = False

LDT_MAX_SEARCH_NUMBER = 50
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 50
LDT_JSON_DEFAULT_INDENT = 0

EMPTY_MEDIA_EXTERNALID = None

AUTO_INDEX_AFTER_SAVE = True

FORBIDDEN_STREAM_URL = "rtmp://media.iri.centrepompidou.fr/ddc_player/mp4:video/forbidden_stream.mp4?old_path="
AUDIO_RECORD_URL = "rtmp://media.iri.centrepompidou.fr/ddc_micro_record"

FRONT_TAG_LIST = ["enmi23", "film", "conférence"]

AUTHENTICATION_BACKENDS = (
    #    'social_auth.backends.twitter.TwitterBackend',
    #    'social_auth.backends.facebook.FacebookBackend',
    #    'social_auth.backends.google.GoogleOAuthBackend',
    #    'social_auth.backends.google.GoogleOAuth2Backend',
    #    'social_auth.backends.google.GoogleBackend',
    #    'social_auth.backends.yahoo.YahooBackend',
    #    'social_auth.backends.contrib.linkedin.LinkedinBackend',
    #    'social_auth.backends.contrib.LiveJournalBackend',
    #    'social_auth.backends.contrib.orkut.OrkutBackend',
    #    'social_auth.backends.OpenIDBackend',
    "django.contrib.auth.backends.ModelBackend",
    "guardian.backends.ObjectPermissionBackend",
)

HAYSTACK_CONNECTIONS = {
    "default": {
        # for elasticsearch use ldt.indexation.backends.elasticsearch_backend.ElasticsearchSearchEngine
        #'ENGINE': 'haystack.backends.simple_backend.SimpleEngine',
        "ENGINE": "ldt.indexation.backends.elasticsearch_backend.ElasticsearchSearchEngine",
        "URL": env.str("ES_HOST", default="es")+":9200",
        "INDEX_NAME": "ldt",
    },
}

POLEMIC_PROTOCOL_DEFINITION = {
    "1": [
        {"name": "OK", "keywords": ["++"], "color": "#1D973D"},
        {"name": "KO", "keywords": ["--"], "color": "#CE0A15"},
        {"name": "REF", "keywords": ["==", "http://"], "color": "#C5A62D"},
        {"name": "Q", "keywords": ["?"], "color": "#036AAE"},
    ],
    "2": [
        {"name": "OK", "keywords": ["++"], "color": "#1D973D"},
        {"name": "KO", "keywords": ["!!"], "color": "#CE0A15"},
        {"name": "REF", "keywords": ["==", "http://"], "color": "#C5A62D"},
        {"name": "Q", "keywords": ["?"], "color": "#036AAE"},
    ],
    "3": [
        {"name": "OK", "keywords": ["++"], "color": "#196be6"},
        {"name": "KO", "keywords": ["??"], "color": "#e6b919"},
        {"name": "REF", "keywords": ["**", "http://", "https://"], "color": "#e619e6"},
        {"name": "Q", "keywords": ["=="], "color": "#42e619"},
    ],
}

USE_X_FORWARDED_HOST = True
SECURE_PROXY_SSL_HEADER = ("x-forwarded-proto", "https")
ALLOWED_HOSTS=["ldt.iri.centrepompidou.fr","127.0.0.1","localhost"]

HTTPLIB2_DISABLE_SSL_CERTIFICATE_VALIDATION = True
