from fabric.api import task, env, sudo

from fablib import (export_version, do_sync_web, create_config, 
    clean_export_folder, sync_install_build, do_create_virtualenv, 
    clean_rsync_folder, rsync_export, do_relaunch_server)
from fabric.colors import green
import imp
import os.path
import config

@task
def relaunch_server(do_collectstatic=True, do_syncdb=True):
    print("Relaunch server")
    do_relaunch_server(do_collectstatic, do_syncdb)

@task
def sync_web(version):
    print(green("sync web with version %s" % version))
    export_path = export_version(web=version)
    export_path_full = os.path.join(export_path,'web')
    do_sync_web(version, export_path_full)
    create_config(export_path_full)
    clean_export_folder(export_path)
    relaunch_server()
    
@task
def update_lib(version, package):
    print(green("update %s with version %s" % (package,version)))
    export_path = export_version(web=version)
    export_path_full = os.path.join(export_path,'web')
    lib_path = os.path.join(export_path_full, "virtualenv", "res", "lib")
    
    f, pathname, description = imp.find_module("patch", [lib_path])
    imp.load_module("patch", f, pathname, description)
    f, pathname, description = imp.find_module("lib_create_env", [lib_path])
    lib_create_env = imp.load_module("lib_create_env", f, pathname, description)
    
    package_path_full = os.path.join(export_path_full, "virtualenv", "res", "src", lib_create_env.URLS[package]['local'])
    
    sync_install_build(package_path_full)
    clean_export_folder(export_path)
    relaunch_server()
    

@task
def create_virtualenv(version):
    print(green("create virtualenv with version %s" % version))
    export_path = export_version(web=version)
    export_path_web = os.path.join(export_path,'web')
    venv_remote_export_path = ""
    try:
        virtualenv_path = os.path.join(export_path_web, "virtualenv")
    
        venv_remote_export_path = os.path.join(env.remote_path['venv_export'], env.export_prefix, version,"virtualenv")
        rsync_export(virtualenv_path, venv_remote_export_path, env.rsync_filters['venv'])
        do_create_virtualenv(venv_remote_export_path, env.remote_path['virtualenv'])
    finally:
        clean_export_folder(export_path)
        if venv_remote_export_path:
            clean_rsync_folder(venv_remote_export_path)
