# -*- coding: utf-8 -*-
'''
Created on Aug 20, 2013

@author: rvelt
'''

from jocondelab.models import DbpediaYears, DbpediaGeo
from core.models import Notice
import django.utils.simplejson as json
from django.http import HttpResponse
from django.conf import settings

def years(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    from_year = request.GET.get('from_year', None)
    to_year = request.GET.get('to_year', None)
    count = request.GET.get('count', 20)
    
    qs = DbpediaYears.objects.filter(term__dbpedia_fields__language_code=lang).order_by('-term__nb_notice')
    
    if to_year:
        qs = qs.filter(start_year__lt=to_year)
    if from_year:
        qs = qs.filter(end_year__gt=to_year)
    
    qs = qs[:count]
    
    results = [{
                "start_year": y.start_year,
                "to_year": y.end_year,
                "term_id": y.term.id,
                "label": y.term.dbpedia_fields.get(language_code=lang).label,
                "nb_notice": y.term.nb_notice,
                "dbpedia_uri": y.term.dbpedia_uri
                } for y in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')

def geo_coords(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    min_lat = request.GET.get('min_lat', None)
    max_lat = request.GET.get('max_lat', None)
    min_lng = request.GET.get('min_lng', None)
    max_lng = request.GET.get('max_lng', None)
    count = request.GET.get('count', 20)
    
    qs = DbpediaGeo.objects.filter(term__dbpedia_fields__language_code=lang).order_by('-term__nb_notice')
    
    if min_lat:
        qs = qs.filter(latitude__gt=min_lat)
    if max_lat:
        qs = qs.filter(latitude__lt=min_lat)
    if min_lng:
        qs = qs.filter(longitude__gt=min_lng)
    if max_lng:
        qs = qs.filter(longitude__lt=min_lng)
    
    qs = qs[:count]
    
    results = [{
                "latitude": y.latitude,
                "longitude": y.longitude,
                "term_id": y.term.id,
                "label": y.term.dbpedia_fields.get(language_code=lang).label,
                "nb_notice": y.term.nb_notice,
                "dbpedia_uri": y.term.dbpedia_uri
                } for y in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')

def contents_by_term(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    count = request.GET.get('count', 20)
    random = ("random" in request.GET and request.GET["random"])
    term_id = request.GET.get('term_id', None)
    
    if term_id is None:
        results = []
    else:
        qs = Notice.objects.filter(noticeterm__term_id=term_id, image=True)
        if random:
            qs = qs.order_by('?')
        qs = qs[:count]
        results = [{
            "title": n.titr if n.titr else n.deno,
            "notice_id": n.id,
            "image": settings.JOCONDE_IMG_BASE_URL + n.images.all()[0].url,
            } for n in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')
    