# -*- coding: utf-8 -*-
'''
Created on Aug 20, 2013

@author: rvelt
'''

from jocondelab.models import DbpediaYears, DbpediaGeo, DbpediaFields
from core.models import Notice, Term
import django.utils.simplejson as json
from django.http import HttpResponse
from django.template.response import TemplateResponse
from django.conf import settings
from jocondelab.views.front_office import get_notices

def years(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    from_year = request.GET.get('from_year', None)
    to_year = request.GET.get('to_year', None)
    count = request.GET.get('count', 20)
    
    qs = DbpediaYears.objects.filter(term__dbpedia_fields__language_code=lang).order_by('-term__nb_notice')
    
    if to_year:
        qs = qs.filter(start_year__lt=to_year)
    if from_year:
        qs = qs.filter(end_year__gt=to_year)
    
    qs = qs[:count]
    
    results = [{
                "start_year": y.start_year,
                "to_year": y.end_year,
                "term_id": y.term.id,
                "label": y.term.dbpedia_fields.get(language_code=lang).label,
                "nb_notice": y.term.nb_notice,
                "dbpedia_uri": y.term.dbpedia_uri
                } for y in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')

def geo_coords(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    min_lat = request.GET.get('min_lat', None)
    max_lat = request.GET.get('max_lat', None)
    min_lng = request.GET.get('min_lng', None)
    max_lng = request.GET.get('max_lng', None)
    count = request.GET.get('count', 20)
    
    qs = DbpediaGeo.objects.filter(term__dbpedia_fields__language_code=lang).order_by('-term__nb_notice')
    
    if min_lat:
        qs = qs.filter(latitude__gt=min_lat)
    if max_lat:
        qs = qs.filter(latitude__lt=max_lat)
    if min_lng:
        qs = qs.filter(longitude__gt=min_lng)
    if max_lng:
        qs = qs.filter(longitude__lt=max_lng)
    
    qs = qs[:count]
    
    results = [{
                "latitude": y.latitude,
                "longitude": y.longitude,
                "term_id": y.term.id,
                "label": y.term.dbpedia_fields.get(language_code=lang).label,
                "nb_notice": y.term.nb_notice,
                "dbpedia_uri": y.term.dbpedia_uri
                } for y in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')

def contents_by_term(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    count = request.GET.get('count', 24)
    random = ("random" in request.GET and request.GET["random"])
    format = request.GET.get('format', 'text/html')
    term_id = request.GET.get('term_id', None)
    
    if term_id is None:
        rescount = 0
        results = []
        termlabel = ""
    else:
        qs = Notice.objects.filter(noticeterm__term_id=term_id, image=True)
        rescount = qs.count()
        if random:
            qs = qs.order_by('?')
        results = get_notices(qs[:count], lang)
        termobj = Term.objects.get(id=term_id)
        termtrans = termobj.dbpedia_fields.filter(language_code = lang)
        termlabel = termtrans[0].label if termtrans.count() else termobj.label
    
    context = {
               "termlabel": termlabel,
               "count": rescount,
               "notices": results
            }
    
    if format == 'text/html':
        return TemplateResponse(request, 'jocondelab/ajax_contents.html', context )
    
    return HttpResponse(content=json.dumps(context), mimetype='application/json')

def geo_search(request):
    
    lang = request.GET.get('lang', request.LANGUAGE_CODE)
    q = request.GET.get('term', None)
    count = request.GET.get('count', 20)
    
    qs = DbpediaGeo.objects.filter(term__dbpedia_fields__language_code=lang, term__dbpedia_fields__label__istartswith=q).order_by('term__dbpedia_fields__label')[:count]
    
    results = [{
                "latitude": d.latitude,
                "longitude": d.longitude,
                "term_id": d.term.id,
                "nb_notice": d.term.nb_notice,
                "dbpedia_uri": d.term.dbpedia_uri,
                "label": d.term.dbpedia_fields.get(language_code=lang).label
                } for d in qs]
    
    return HttpResponse(content=json.dumps(results), mimetype='application/json')
    