from django import template

register = template.Library()

@register.inclusion_tag('jocondelab/partial/datasheet_row.html', takes_context=True)
def show_datasheet_row(context, fieldname, **kwargs):
    return {
            "fieldname": fieldname,
            "linked_terms": context['terms_by_thesaurus'].get(fieldname.upper(),None),
            "base_field": getattr(context['object'],fieldname.lower()),
            "row_class": kwargs.get("row_class", None)
    }