from core.models import User, Notice, Term, Thesaurus
from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as AuthUserAdmin
from django.utils.translation import gettext_lazy as _
from core.forms import UserChangeForm, UserCreationform

class UserAdmin(AuthUserAdmin):
    form = UserChangeForm
    add_form = UserCreationform
    fieldsets = tuple(list(AuthUserAdmin.fieldsets) + [(_('language'), {'fields':('language',)})])


admin.site.register(User, UserAdmin)

admin.site.register(Notice)
admin.site.register(Term)
admin.site.register(Thesaurus)


