# -*- coding: utf-8 -*-
'''
Created on Jun 12, 2013

@author: ymh
'''
from django.conf import settings
from django.contrib.auth.models import AbstractUser
from django.db import models

class User(AbstractUser):
    language = models.CharField(max_length=2, default=settings.LANGUAGE_CODE[:2])

class Country(models.Model):
    dbpedia_uri = models.URLField(max_length=2048, unique=True, blank=False, null=False, db_index=True)
    iso_code_3 = models.CharField(max_length=3, unique=False, blank=False, null=False, db_index=True)
    iso_code_2 = models.CharField(max_length=2, unique=False, blank=False, null=False, db_index=True)

class DbpediaResource(models.Model):
    uri = models.URLField(max_length=2048, unique=True, blank=False, null=False, db_index=True)
    lang = models.CharField(max_length=128, unique=False, blank=False, null=False, db_index=True)

class DbpediaTranslation(models.Model):
    dbpediaresource = models.ForeignKey(DbpediaResource, blank=False, null=False, db_index=True, related_name="translations")
    lang = models.CharField(max_length=15, unique=False, blank=False, null=False, db_index=True)
    label = models.CharField(max_length=2048, unique=False, blank=True, null=False, db_index=True)
    
    class Meta:
        unique_together = ('dbpediaresource', 'lang')
