# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import transaction, reset_queries
from django.conf import settings
from core.models import Term
from core.utils import show_progress

class Migration(SchemaMigration):

    def forwards(self, orm):
        # Filling table 'DbpediaResource'
        dbres_from_terms = Term.objects.distinct('dbpedia_uri').exclude(dbpedia_uri=None).order_by('dbpedia_uri').values_list('dbpedia_uri',flat=True)
        
        total = len(dbres_from_terms)
        
        transaction.enter_transaction_management(True)
        transaction.managed()

        writer = None
        for i, dbpedia_uri in enumerate(dbres_from_terms):
            
            writer = show_progress(i+1, total, "%s" % dbpedia_uri, 50, writer)
            
            lang = 'fr'
            for k in settings.WIKIPEDIA_URLS:
                prefix = settings.WIKIPEDIA_URLS[k]['dbpedia_uri']%""
                if dbpedia_uri.find(prefix) == 0:
                    lang = k
            
            orm['jocondelab.dbpediaresource'].objects.create(
                                           uri = dbpedia_uri,
                                           lang = lang)

            if not ((i+1) % 5000):
                transaction.commit()
                reset_queries() 
                
        transaction.commit()
        reset_queries()
        transaction.leave_transaction_management()


    def backwards(self, orm):
        # Clearing table 'DbpediaResource'
        db.clear_table(u'jocondelab_dbpediaresource')


    models = {
        u'auth.group': {
            'Meta': {'object_name': 'Group'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        u'auth.permission': {
            'Meta': {'ordering': "(u'content_type__app_label', u'content_type__model', u'codename')", 'unique_together': "((u'content_type', u'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'jocondelab.country': {
            'Meta': {'object_name': 'Country'},
            'dbpedia_uri': ('django.db.models.fields.URLField', [], {'unique': 'True', 'max_length': '2048', 'db_index': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'iso_code_2': ('django.db.models.fields.CharField', [], {'max_length': '2', 'db_index': 'True'}),
            'iso_code_3': ('django.db.models.fields.CharField', [], {'max_length': '3', 'db_index': 'True'})
        },
        u'jocondelab.dbpediaresource': {
            'Meta': {'object_name': 'DbpediaResource'},
            'uri': ('django.db.models.fields.URLField', [], {'unique': 'True', 'max_length': '2048', 'db_index': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'lang': ('django.db.models.fields.CharField', [], {'max_length': '128', 'db_index': 'True'})
        },
        u'jocondelab.dbpediatranslation': {
            'Meta': {'unique_together': "(('dbpediaresource', 'lang'),)", 'object_name': 'DbpediaTranslation'},
            'dbpediaresource': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'translations'", 'to': u"orm['jocondelab.DbpediaResource']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'db_index': 'True', 'max_length': '2048', 'blank': 'True'}),
            'lang': ('django.db.models.fields.CharField', [], {'max_length': '15', 'db_index': 'True'})
        },
        u'jocondelab.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'language': ('django.db.models.fields.CharField', [], {'default': "'en'", 'max_length': '2'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        }
    }

    complete_apps = ['jocondelab']