# -*- coding: utf-8 -*-
'''
Created on Jul 31, 2013

@author: ymh
'''
from django.db import models
from core.models import Term

class Country(models.Model):
    dbpedia_uri = models.URLField(max_length=2048, unique=True, blank=False, null=False, db_index=True)
    iso_code_3 = models.CharField(max_length=3, unique=False, blank=False, null=False, db_index=True)
    iso_code_2 = models.CharField(max_length=2, unique=False, blank=False, null=False, db_index=True)

    class Meta:
        app_label = 'jocondelab'


class DbpediaFields(models.Model):
     
    dbpedia_uri = models.URLField(max_length=2048, blank=False, null=False, db_index=True, unique=False)
    language_code = models.CharField(max_length=15, blank=False, null=False, db_index=True)
    term = models.ForeignKey(Term, blank=False, null=False, db_index=True, related_name="dbpedia_fields")
    thumbnail = models.URLField(max_length=2048, blank=True, null=True, db_index=False)    
    label = models.CharField(max_length=2048, unique=False, blank=True, null=True)
    abstract = models.TextField(blank=True, null=True)
 
    class Meta:
        app_label = 'jocondelab'
 
class TermLinks(models.Model):
     
    subject = models.ForeignKey(Term, blank=False, null=False, db_index=True, related_name="termlinks_subjects")
    object = models.ForeignKey(Term, blank=False, null=False, db_index=True, related_name="termlinks_objects")
     
    class Meta:
        app_label = 'jocondelab'

class DbpediaYears(models.Model):
    term = models.ForeignKey(Term, unique=True, blank=False, null=False, db_index=True, related_name="years")
    start_year = models.IntegerField(null=False, blank=False, db_index=True)
    end_year = models.IntegerField(null=False, blank=False, db_index=True)
    
    class Meta:
        app_label = 'jocondelab'

class DbpediaGeo(models.Model):
    term = models.ForeignKey(Term, unique=True, blank=False, null=False, db_index=True, related_name="geo")
    latitude = models.FloatField(null=False, blank=False, db_index=True)
    longitude = models.FloatField(null=False, blank=False, db_index=True)
    
    class Meta:
        app_label = 'jocondelab'