﻿// -*- coding: utf-8 -*-
function fill_wp_infobox(item) {

    var wp_infobox = $("#wp-infobox");
    if(wp_infobox.length === 0) {
        wp_infobox = $("<div>",{id: 'wp-infobox'}).addClass( "ui-widget-content ui-corner-all").appendTo('body');
    }
    
    wp_infobox.find('img').off('error');
    
    var html_str = "<h3>"+item.label+"</h3>" +
    (item.original_label !== item.label ? "<h4>" + gettext("Redirected from: ") + item.original_label+"</h4>":"") +
    "<div class='wp-infobox-wp-link'>" +
    "<a target='_blank' href='"+ item.url +"'>Source wikipedia</a>" +
    "</div>" +
    "<img class='wp-img"+ ((!item.thumbnail)?" wp-missing-img":"") + "' src=\""+ item.thumbnail+"\"/>" +
    "<div>" + item.abstract + "</div>" ;
    
    
    wp_infobox.html(html_str);
    
    wp_infobox.find('img').error(function(){
        $(this).addClass('wp-missing-img');
    });
    
    wp_infobox
        .position({my: "left top", at:"right+5 top", of: $(".ui-autocomplete")})
        .css("z-index", $(".ui-autocomplete").css("z-index"))
        .show();
}

function get_dp_sparql(resource_url) {
    return "select distinct ?s ?t ?y ?l ?r where { " +
    "<"+resource_url+"> rdfs:label ?s . " +
    "OPTIONAL { <"+resource_url+"> dbpedia-owl:thumbnail ?t } . " +
    "OPTIONAL { <"+resource_url+"> dbpedia-owl:abstract ?y . FILTER(langMatches(lang(?y), \"fr\")) } . "+
    "OPTIONAL { <"+resource_url+"> foaf:isPrimaryTopicOf ?l } " +
    "OPTIONAL { <"+resource_url+"> dbpedia-owl:wikiPageRedirects ?r } " +
    "} LIMIT 100"
}

function get_dp_ajax(resource_url) {
    return $.ajax({
        url: "http://fr.dbpedia.org/sparql",
        data: {
            query: get_dp_sparql(resource_url),
            format: "application/sparql-results+json"
        },
        dataType: "json",
        cache: true
    })
}

function init_term_events()
{
    // Tag simple operations : activate/unactivate wp link, remove wp link
    $(".remove_wp_link").click(function(e){
        msg = interpolate(gettext("Confirmez-vous la suppression du lien Wikipédia pour le terme \"%s\" ?"),[$(this).attr('alt')]);
        if(confirm(msg)){
            delete_link(this);
        }
    });
    
    $(".wikipedia_edition").click(function(e) {
        $.post(term_wikipedia_edition_url,
            {
                csrfmiddlewaretoken:global_csrf_token, 
                term_id:term_id,
                wikipedia_edition: $(this).is(':checked')
            },
            function(data, textStatus) {
                window.location.reload(true);
            }
        );
    });
    
    $("#link_semantic_level").change(function(e) {
        $.post(link_semantic_level_url,
            {
                csrfmiddlewaretoken:global_csrf_token, 
                term_id:term_id,
                link_semantic_level: $("#link_semantic_level").val()
            },
            function(data, textStatus) {
                window.location.reload(true);
            }
        );
    });
    
    // Wikipedia search management (new tag)
    $("#wp_search").autocomplete({
        source: function( request, response ) {
            $.ajax({
               url : "http://fr.wikipedia.org/w/api.php",
               dataType: "jsonp",
               data : {
                   action: "opensearch",
                   search: request.term,
                   format: "json",
                   limit: 10                   
               },
               success: function( data ) {
                   response( $.map( data[1], function( item ) {
                       return {
                           label: item,
                           value: item
                       };
                   }));
               }
            });
        },
        select: function(event, ui) { 
            // Since the event still did not update wp_search's val, we force it.
            $("#wp_search").val(ui.item.label);
            select_done = true;
            $("#ok_search").click();
        },
        minLength: 2,
        open: function() {
            $( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
        },
        close: function() {
            $( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
            setTimeout(function(){$("#wp-infobox").hide();},500);
        },
        focus: function(event,ui) {
            
            var page_name = ui.item.label.replace(/ /g, "_");
            var resource_url = "http://fr.dbpedia.org/resource/" + page_name;
            var request = get_dp_ajax(resource_url),
                chained = request.then(function(data) {
                        res = data.results.bindings.length>0?data.results.bindings[0]:{y:"",l:"http://fr.wikipedia.org/"+page_name,t:"", r:""};                        
                        if(res.r) {
                            return get_dp_ajax(res.r.value);
                        }
                        else {
                            return data;
                        }
                });
            
            chained.done(function(data) {
                res = data.results.bindings.length>0?data.results.bindings[0]:{s:ui.item.label, y:"",l:"http://fr.wikipedia.org/"+page_name,t:"", r:""};                
                var item = {
                    label : res.s?res.s.value:ui.item.label,
                    original_label : ui.item.label,
                    abstract: res.y?res.y.value:"",
                    url: res.l?res.l.value:"",
                    thumbnail: res.t?res.t.value:""
                };                
                fill_wp_infobox(item);
            });
        }
    })
    .data( "ui-autocomplete" )._renderItem = function( ul, item ) {
        label = item.titlesnippet;
        if(!label) {
            label = item.label;
        }
        return $( "<li></li>" )
        .data( "item.autocomplete", item )
        .append( "<a>" + label + "</a>" )
        .appendTo( ul );
    };
    $('#wp_search').keyup(function(e){
        if((e.keyCode==13) && ($("#wp_search").val()!="") && (select_done==false)){
            update_link($("#wp_search").val());
        }
        select_done = false;
    });
    $("#ok_search").click(function(){
        if($("#wp_search").val()!=""){
            update_link($("#wp_search").val());
        }
    });
    // Validate sheet management : the radiobutton name has is "'gr_validated' + datasheet.hda_id"
    $("input[type='radio'][name='gr_validated']").click(function(e){
        e.preventDefault();
        val = $("input[type='radio'][name='gr_validated']:checked").val();
        if(val === 'True') {
            msg = gettext("Confirmez-vous la validation de ce terme ?");            
        }
        else {
            msg = gettext("Confirmez-vous l'invalidation de cette fiche ?");
        }
        if(confirm(msg)) {
            $.post(validate_term_url,{term_id: term_id, validation_val: val, csrfmiddlewaretoken: global_csrf_token},function(data) {
                window.location.reload(true);
            });
        }
    });    
}


function delete_link(btn)
{
    if ($(btn).is(".remove_wp_link")) {
        var url = remove_wp_link_url;
        var term_id = $(btn).attr('id');
    }

    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               term_id:term_id,
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
		error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
			$(btn).html(id_tag);
		}
    });
}

function update_link(tag_label)
{
    $("#ok_search").html("<img src='"+static_url+"jocondelab/img/indicator.gif'>");
    var url = modify_wp_link_url;
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               term_id:term_id,
               label:tag_label
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
        error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
        },
        complete: function(){
            // We empty the input and hide the ok button
            $("#wp_search").val("");
            $("#ok_search").html("<b>OK</b>");
        }
    });
}

function init_filter_events() {
    $('#term-filter-form').submit(function(){
        var values = $('#term-filter-form').serialize();
        $('#term-explorer-container').load(term_list_table_url, values, function() {
            init_edit_page();
        });
        return false;
    });
}

function init_edit_page() {
    $('#term-list-table #term-'+term_id).addClass('currenttermline');

    $('.pagination a').click(function(e) {
        e.preventDefault();
        console.log(this);
        var values = this.href.slice(window.location.href.indexOf('?') + 1) 
        $('#term-explorer-container').load(term_list_table_url, values, function() {
            init_edit_page();
        });
        return false;
    });
}

