# -*- coding: utf-8 -*-
'''
Created on Jun 10, 2013

@author: ymh
'''

from django.conf import settings

JOCONDE_IMAGE_BASE_URL = getattr(settings, 'JOCONDE_IMAGE_BASE_URL', '')

AUTR_CONTEXT  = getattr(settings,'AUTR_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T513')
DOMN_CONTEXT  = getattr(settings,'DOMN_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T51')
ECOL_CONTEXT  = getattr(settings,'ECOL_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T517')
EPOQ_CONTEXT  = getattr(settings,'EPOQ_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T93')
LIEUX_CONTEXT = getattr(settings,'LIEUX_CONTEXT', 'http://data.culture.fr/thesaurus/resource/ark:/67717/T84')
PERI_CONTEXT  = getattr(settings,'LIEUX_CONTEXT', 'http://data.culture.fr/thesaurus/resource/ark:/67717/T521')
REPR_CONTEXT  = getattr(settings,'REPR_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T523')
SREP_CONTEXT  = getattr(settings,'SREP_CONTEXT' , 'http://data.culture.fr/thesaurus/resource/ark:/67717/T507')


WIKIPEDIA_URLS = getattr(settings, "WIKIPEDIA_URLS", {
    'fr': {
        'base_url': "http://fr.wikipedia.org",
        'page_url': "http://fr.wikipedia.org/wiki",
        'api_url': "http://fr.wikipedia.org/w/api.php",
        'permalink_tmpl': "http://fr.wikipedia.org/w/index.php?oldid=%s",
        'dbpedia_uri' : "http://fr.dbpedia.org/resource/%s",
        'dbpedia_sparql_url' : "http://fr.dbpedia.org/sparql",
        'dbpedia_sparql_use_proxy': False,
        'disambiguation_cat' : u'Catégorie:Homonymie',
    },
    'en': {
        'base_url': "http://en.wikipedia.org",
        'page_url': "http://en.wikipedia.org/wiki",
        'api_url': "http://en.wikipedia.org/w/api.php",
        'permalink_tmpl': "http://en.wikipedia.org/w/index.php?oldid=%s",
        'dbpedia_uri' : "http://dbpedia.org/resource/%s",
        'dbpedia_sparql_url' : "http://dbpedia.org/sparql",
        'dbpedia_sparql_use_proxy': False,
        'disambiguation_cat' : u'Category:Disambiguation pages',
    },
    'it': {
        'base_url': "http://it.wikipedia.org",
        'page_url': "http://it.wikipedia.org/wiki",
        'api_url': "http://it.wikipedia.org/w/api.php",
        'permalink_tmpl': "http://it.wikipedia.org/w/index.php?oldid=%s",
        'dbpedia_uri' : "http://it.dbpedia.org/resource/%s",
        'dbpedia_sparql_url' : "http://it.dbpedia.org/sparql",
        'dbpedia_sparql_use_proxy': True,
        'disambiguation_cat' : u'Categoria:Disambigua',
    },
    'de': {
        'base_url': "http://de.wikipedia.org",
        'page_url': "http://de.wikipedia.org/wiki",
        'api_url': "http://de.wikipedia.org/w/api.php",
        'permalink_tmpl': "http://de.wikipedia.org/w/index.php?oldid=%s",
        'dbpedia_uri' : "http://de.dbpedia.org/resource/%s",
        'dbpedia_sparql_url' : "http://de.dbpedia.org/sparql",
        'dbpedia_sparql_use_proxy': True,
        'disambiguation_cat' : u'Kategorie:Begriffsklärung',
    },
    'ja': {
        'base_url': "http://ja.wikipedia.org",
        'page_url': "http://ja.wikipedia.org/wiki",
        'api_url': "http://ja.wikipedia.org/w/api.php",
        'permalink_tmpl': "http://ja.wikipedia.org/w/index.php?oldid=%s",
        'dbpedia_uri' : "http://ja.dbpedia.org/resource/%s",
        'dbpedia_sparql_url' : "http://ja.dbpedia.org/sparql",
        'dbpedia_sparql_use_proxy': False,
        'disambiguation_cat' : u'カテゴリ:同名の地名',
    },
})


