﻿// -*- coding: utf-8 -*-
function init_term_events()
{
    // Tag simple operations : activate/unactivate wp link, remove wp link
    $(".remove_wp_link").click(function(e){
        msg = interpolate(gettext("Confirmez-vous la suppression du lien Wikipédia pour le terme \"%s\" ?"),[$(this).attr('alt')]);
        if(confirm(msg)){
            delete_link(this);
        }
    });
    
    $(".wikipedia_edition").click(function(e) {
        console.log(term_wikipedia_edition_url,$(this),$(this).is(':checked'));
        $.post(term_wikipedia_edition_url,
            {
                csrfmiddlewaretoken:global_csrf_token, 
                term_id:term_id,
                wikipedia_edition: $(this).is(':checked')
            },
            function(data, textStatus) {
                window.location.reload(true);
            }
        );
    });
    
    $("#link_semantic_level").change(function(e) {
        $.post(link_semantic_level_url,
            {
                csrfmiddlewaretoken:global_csrf_token, 
                term_id:term_id,
                link_semantic_level: $("#link_semantic_level").val()
            },
            function(data, textStatus) {
                window.location.reload(true);
            }
        );
    });
    
    // Wikipedia search management (new tag)
    $("#wp_search").autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "http://fr.wikipedia.org/w/api.php",
                dataType: "jsonp",
                data: {
                    list: "search",
                    action: "query",
                    srlimit: "20",
                    format: "json",
                    srsearch: request.term,
                    srprop: 'titlesnippet|snippet',
                },
                success: function( data ) {
                    response( $.map( data.query.search, function( item ) {
                        return {
                            label: item.title,
                            value: item.title,
                            snippet: item.snippet,
                            titlesnippet: item.titlesnippet
                        }
                    }));
                }
            });
            //response( $.map(
            //    JSON.parse('[{"ns":0,"title":"Napol\u00e9on Ier","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> , n\u00e9 le 15 | ao\u00fbt | 1769 \u00e0 Ajaccio  en Corse , dans le royaume de France , et mort le 5 | mai | 1821 sur l\'\u00eele Sainte-H\u00e9l\u00e8ne , au  <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> Ier"},{"ns":0,"title":"Napol\u00e9on III","snippet":"Charles Louis <span class=\'searchmatch\'>Napol\u00e9on</span> Bonaparte, dit Louis-<span class=\'searchmatch\'>Napol\u00e9on</span> Bonaparte puis <span class=\'searchmatch\'>Napol\u00e9on</span> III, est n\u00e9 \u00e0 Paris , le 20 | avril | 1808 et mort \u00e0  <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> III"},{"ns":0,"title":"Famille Bonaparte","snippet":"Trois de ses membres ont r\u00e9gn\u00e9 sur la France  dans le cadre de la monarchie imp\u00e9riale fran\u00e7aise  : <span class=\'searchmatch\'>Napol\u00e9on</span> I er  (de 1804  \u00e0 1814 , puis  <b>...</b> ","titlesnippet":""},{"ns":0,"title":"Napol\u00e9on (film, 1927)","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> est le titre de r\u00e9f\u00e9rence d\'un film historique fran\u00e7ais, r\u00e9alis\u00e9 par Abel Gance , sorti initialement en 1927, dont le titre \u00e0  <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> (film, 1927)"},{"ns":0,"title":"Guerres napol\u00e9oniennes","snippet":"Les Guerres napol\u00e9oniennes sont la s\u00e9rie de guerre s qui eurent lieu en Europe  lorsque <span class=\'searchmatch\'>Napol\u00e9on</span>  dirigeait la France . Elles sont en partie <b>...</b> ","titlesnippet":""},{"ns":0,"title":"Napol\u00e9on (film, 1955)","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> est un film franco -italien  r\u00e9alis\u00e9 par Sacha Guitry  en 1954 , sorti en salles en 1955 .  R\u00e9sum\u00e9 de l\'\u0153uvre : vie de <span class=\'searchmatch\'>Napol\u00e9on</span> de  <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> (film, 1955)"},{"ns":0,"title":"Napol\u00e9on II","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> Fran\u00e7ois Charles Joseph Bonaparte, prince imp\u00e9rial , titr\u00e9 roi de Rome  \u00e0 sa naissance, puis prince de Parme, proclam\u00e9 <span class=\'searchmatch\'>Napol\u00e9on</span> II <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> II"},{"ns":0,"title":"Louis-Napol\u00e9on Bonaparte (1856-1879)","snippet":"Le prince <span class=\'searchmatch\'>Napol\u00e9on</span> Eug\u00e8ne Louis Jean Joseph Bonaparte, prince imp\u00e9rial , dit Louis-<span class=\'searchmatch\'>Napol\u00e9on</span>, n\u00e9 le 16 | mars | 1856 \u00e0 Paris  et mort le 1er <b>...</b> ","titlesnippet":"Louis-<span class=\'searchmatch\'>Napol\u00e9on</span> Bonaparte (1856-1879)"},{"ns":0,"title":"Napol\u00e9on (mini-s\u00e9rie)","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> est une mini-s\u00e9rie  historique compos\u00e9e de quatre \u00e9pisodes de 100 | minutes, r\u00e9alis\u00e9e par Yves Simoneau  et diffus\u00e9e \u00e0 partir du <b>...</b> ","titlesnippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> (mini-s\u00e9rie)"},{"ns":0,"title":"Victor Napol\u00e9on","snippet":"<span class=\'searchmatch\'>Napol\u00e9on</span> Victor J\u00e9r\u00f4me Fr\u00e9d\u00e9ric Bonaparte, dit Victor <span class=\'searchmatch\'>Napol\u00e9on</span>, \u00ab prince <span class=\'searchmatch\'>Napol\u00e9on</span>  \u00bb, n\u00e9 le 18 juillet  1862 , mort le 3 mai  1926 , est le <b>...</b> ","titlesnippet":"Victor <span class=\'searchmatch\'>Napol\u00e9on</span>"}]'),
            //    function( item ) {
            //        return {
            //            label: item.title,
            //            value: item.title,
            //            snippet: item.snippet,
            //            titlesnippet: item.titlesnippet
            //        };
            //    }
            //));
        },
        select: function(event, ui) { 
            // Since the event still did not update wp_search's val, we force it.
            $("#wp_search").val(ui.item.label);
            select_done = true;
            $("#ok_search").click();
        },
        minLength: 2,
        open: function() {
            $( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
        },
        close: function() {
            $( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
            setTimeout(function(){$("#wp-infobox").hide();},500);
        },
        focus: function(event,ui) {
            
            var wp_infobox = $("#wp-infobox");
            if(wp_infobox.length === 0) {
                wp_infobox = $("<div>",{id: 'wp-infobox'}).addClass( "ui-widget-content ui-corner-all").appendTo('body');
            }
            label = ui.item.titlesnippet;
            if(!label) {
                label = ui.item.label;
            }
            var html_str = "<h3>"+label+"</h3>" +
                "<div>" + ui.item.snippet + "</div>" +
                "<div class='wp-infobox-wp-link'>" +
                    "<a target='_blank' href='http://fr.wikipedia.org/wiki/"+encodeURIComponent(ui.item.label)+"'>Source wikipedia</a>" +
                "</div>";
            wp_infobox
                .html(html_str)
                .position({my: "left top", at:"right+5 top", of: $(".ui-autocomplete")})
                .css("z-index", $(".ui-autocomplete").css("z-index"))
                .show();
        }
    })
    .data( "ui-autocomplete" )._renderItem = function( ul, item ) {
        label = item.titlesnippet;
        if(!label) {
            label = item.label;
        }
        return $( "<li></li>" )
        .data( "item.autocomplete", item )
        .append( "<a>" + label + "</a>" )
        .appendTo( ul );
    };
    $('#wp_search').keyup(function(e){
        if((e.keyCode==13) && ($("#wp_search").val()!="") && (select_done==false)){
            update_link($("#wp_search").val());
        }
        select_done = false;
    });
    $("#ok_search").click(function(){
        if($("#wp_search").val()!=""){
            update_link($("#wp_search").val());
        }
    });
    // Validate sheet management : the radiobutton name has is "'gr_validated' + datasheet.hda_id"
    $("input[type='radio'][name='gr_validated']").click(function(e){
        e.preventDefault();
        console.log(e);
        val = $("input[type='radio'][name='gr_validated']:checked").val();
        if(val === 'True') {
            msg = gettext("Confirmez-vous la validation de ce terme ?");            
        }
        else {
            msg = gettext("Confirmez-vous l'invalidation de cette fiche ?");
        }
        if(confirm(msg)) {
            $.post(validate_term_url,{term_id: term_id, validation_val: val, csrfmiddlewaretoken: global_csrf_token},function(data) {
                window.location.reload(true);
            });
        }
    });    
}


function delete_link(btn)
{
    if ($(btn).is(".remove_wp_link")) {
        var url = remove_wp_link_url;
        var term_id = $(btn).attr('id');
    }

    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               term_id:term_id,
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
		error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
			$(btn).html(id_tag);
		}
    });
}

function update_link(tag_label)
{
    $("#ok_search").html("<img src='"+static_url+"jocondelab/img/indicator.gif'>");
    var url = modify_wp_link_url;
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               term_id:term_id,
               label:tag_label
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
        error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
        },
        complete: function(){
            // We empty the input and hide the ok button
            $("#wp_search").val("");
            $("#ok_search").html("<b>OK</b>");
        }
    });
}

function init_filter_events() {
    $('#term-filter-form').submit(function(){
        var values = $('#term-filter-form').serialize();
        $('#term-explorer-container').load(term_list_table_url, values, function() {
            $('#term-list-table #term-'+term_id).addClass('currenttermline');
        });
        return false;
    });
}

function init_edit_page(page) {
    var values = $('#term-filter-form').serialize();
    // add page
    if(typeof(page) !== "undefined" && page) { 
        values += "&page="+page;
    }
    $('#term-explorer-container').load(term_list_table_url, values, function() {
        $('#term-list-table #term-'+term_id).addClass('currenttermline');
    });

}

