# -*- coding: utf-8 -*-
'''
Created on Jun 16, 2013

@author: ymh
'''

from django.conf import settings
from django.core.paginator import Paginator, Page, PageNotAnInteger, EmptyPage
import logging

logger = logging.getLogger(__name__)


class JocondePaginator(Paginator):

    def validate_number(self, number):
        "Validates the given 1-based page number."
        try:
            number = int(number)
        except (TypeError, ValueError):
            raise PageNotAnInteger('That page number is not an integer')
        if number < 1:
            return 1
        if number > self.num_pages:
            if number == 1 and self.allow_empty_first_page:
                return 1
            elif self.num_pages > 0: 
                return self.num_pages
            else:
                raise EmptyPage('That page contains no results')
        return number

    
    def page(self, number):        
        page = super(JocondePaginator, self).page(number)
        return JocondePage(page.object_list, page.number, self)


class JocondePage(Page):
    
    def __get_start_range(self):
        return max(1,self.number-settings.PAGINATOR_VISIBLE_RANGE/2)
    
    def __get_end_range(self):
        return min(self.paginator.num_pages, self.number+settings.PAGINATOR_VISIBLE_RANGE/2) + 1
    
    def visible_page_range(self):
        start = self.__get_start_range()
        end = self.__get_end_range()
        return range(start , end) 
    
    def ellipsis_before(self):
        return self.__get_start_range() > 1
    
    def ellipsis_after(self):
        return self.__get_end_range() < self.paginator.num_pages
