from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as AuthUserAdmin
from django.utils.translation import gettext_lazy as _
from jocondelab.forms import UserChangeForm, UserCreationform
from jocondelab.models import User


class UserAdmin(AuthUserAdmin):
    form = UserChangeForm
    add_form = UserCreationform
    fieldsets = tuple(list(AuthUserAdmin.fieldsets) + [(_('language'), {'fields':('language',)})])


admin.site.register(User, UserAdmin)
