# -*- coding: utf-8 -*-
'''
Created on Jun 13, 2013

@author: ymh
'''
from core.models import Thesaurus, Term, TERM_URL_STATUS_CHOICES
from django.forms import Form, fields, ModelChoiceField
from django.utils.translation import ugettext_lazy as tr


class ValidateTermForm(Form):
    term_id = fields.IntegerField(required=True)
    validation_val = fields.BooleanField(required=False)
    
class ModifyWpLinkForm(Form):
    term_id = fields.IntegerField(required=True)
    label = fields.CharField(required=True, min_length=1)

class RemoveWpLinkForm(Form):
    term_id = fields.IntegerField(required=True)

def validated_to_bool(val):
    if isinstance(val, basestring) and len(val)==0:
        return None
    else:
        return bool(int(val))
         
class TermFilterForm(Form):
    order_by = fields.ChoiceField(required=False, choices=(('normalized_label','label'),('uri','uri')))
    order_dir = fields.ChoiceField(required=False, choices=(('asc','asc'), ('desc','desc')))
    thesaurus = ModelChoiceField(required=False, queryset=Thesaurus.objects.all())
    label = fields.CharField(required=False)
    link_status = fields.TypedChoiceField(required=False, empty_value=-1, coerce=int, choices=tuple([(-1,'---------')]+[(v, tr(l)) for v,l in TERM_URL_STATUS_CHOICES]))
    validated = fields.TypedChoiceField(required=False, empty_value=None, coerce=validated_to_bool, choices=(("", "---"),("1", tr("yes")), ("0", tr("no"))))
    
    def get_filter_qs(self, base_qs=None):
        qs = base_qs
        if qs is None:
            qs = Term.objects.all()
        
        thes = self.cleaned_data.get('thesaurus',None)
        if thes:
            qs = qs.filter(thesaurus=thes)
            
        lk_status = self.cleaned_data.get('link_status',-1)
        if lk_status>=0:
            qs = qs.filter(url_status=lk_status)
            
        validated = self.cleaned_data.get('validated', None)
        if validated is not None:
            qs = qs.filter(validated=validated)
            
        label_regexp = self.cleaned_data.get('label', None)
        if label_regexp:
            qs = qs.filter(label__iregex=label_regexp)
        
        order_by = self.cleaned_data.get('order_by', 'normalized_label') or 'normalized_label'
        order_dir = self.cleaned_data.get('order_dir', 'asc') or 'asc'
        if order_dir == 'desc':
            order_by = "-"+order_by
        qs = qs.order_by(order_by)
        
        return qs