# -*- coding: utf-8 -*-
'''
Created on Jun 16, 2013

@author: ymh
'''

from core.models import Term
from django.conf import settings
from django.core.paginator import Paginator, Page, PageNotAnInteger, EmptyPage
import logging

logger = logging.getLogger(__name__)


class JocondePaginator(Paginator):

    def validate_number(self, number):
        "Validates the given 1-based page number."
        try:
            number = int(number)
        except (TypeError, ValueError):
            raise PageNotAnInteger('That page number is not an integer')
        if number < 1:
            return 1
        if number > self.num_pages:
            if number == 1 and self.allow_empty_first_page:
                return 1
            elif self.num_pages > 0: 
                return self.num_pages
            else:
                raise EmptyPage('That page contains no results')
        return number

    
    def page(self, number):        
        page = super(JocondePaginator, self).page(number)
        return JocondePage(page.object_list, page.number, self)


class JocondePage(Page):
    
    visible_range = getattr(settings, 'PAGINATOR_VISIBLE_RANGE', 5)
    start_range = getattr(settings, 'PAGINATOR_START_RANGE', visible_range/2)
    
    def __init__(self, object_list, number, paginator):
        self.number = number
        self.paginator = paginator
        self.orginal_object_list = object_list
    
    def __get_start_range(self):
        return max(1,self.number-self.visible_range/2)
    
    def __get_end_range(self):
        return min(self.paginator.num_pages, self.number+self.visible_range/2) + 1
    
    def visible_page_range(self):        
        start = self.__get_start_range()
        end = self.__get_end_range()
                
        ranges = set(range(1,self.start_range+1)) | set(range(start , end)) | set(range(self.paginator.num_pages - self.start_range +1, self.paginator.num_pages+1))         
        prev = None
        res = []
        for i in sorted(ranges):
            if 1 <= i <= self.paginator.num_pages:
                if prev and i-prev > 1:
                    res.append(0)
                res.append(i)
                prev = i
        return res
    
    def object_list(): #@NoSelf
        doc = """Get proxy object list""" #@UnusedVariable
       
        def fget(self):
            term_dict = dict([(t.id,t) for t in Term.objects.filter(id__in=[d['id'] for d in self.orginal_object_list]).select_related()])
            
            def map_object(t):
                mapped_obj = term_dict[t['id']]
                mapped_obj.nb_notice = t['nb_notice']
                return mapped_obj
            
            return map(map_object, self.orginal_object_list)
                      
        return locals()
       
    object_list = property(**object_list())