# -*- coding: utf-8 -*-
'''
Created on Jun 13, 2013

@author: ymh
'''
from core.models import Thesaurus, Term, TERM_URL_STATUS_CHOICES_TRANS
from django.forms import Form, fields, ModelChoiceField
from django.utils.translation import ugettext_lazy as _


class ValidateTermForm(Form):
    term_id = fields.IntegerField(required=True)
    validation_val = fields.BooleanField(required=False)

class WikipediaEditionForm(Form):
    term_id = fields.IntegerField(required=True)
    wikipedia_edition = fields.BooleanField(required=False)
    
class ModifyWpLinkForm(Form):
    term_id = fields.IntegerField(required=True)
    label = fields.CharField(required=True, min_length=1)

class LinkSemanticLevelForm(Form):
    term_id = fields.IntegerField(required=True)
    link_semantic_level = fields.IntegerField(required=True)

class RemoveWpLinkForm(Form):
    term_id = fields.IntegerField(required=True)

def validated_to_bool(val):
    if isinstance(val, basestring) and len(val)==0:
        return None
    else:
        return bool(int(val))
         
class TermFilterForm(Form):
    thesaurus = ModelChoiceField(label=_("thesaurus"), required=False, queryset=Thesaurus.objects.all().order_by('label'))
    label = fields.CharField(label=_("label"), required=False)
    link_status = fields.TypedChoiceField(label=_("link_status"), required=False, empty_value=-1, coerce=int, choices=tuple([(-1,'---------')]+[(v, l) for v,l in TERM_URL_STATUS_CHOICES_TRANS]))
    validated = fields.TypedChoiceField(label=_("validated"), required=False, empty_value=None, coerce=validated_to_bool, choices=(("", "---"),("1", _("yes")), ("0", _("no"))))
    order_by = fields.ChoiceField(label=_("order_by"), required=False, choices=(('normalized_label',_('label')),('nb_notice',_('nb notice'))))
    order_dir = fields.ChoiceField(label=_("order_dir"), required=False, choices=(('asc',_('asc')), ('desc',_('desc'))))
    
    def get_filter_qs(self, base_qs=None):
        qs = base_qs
        if qs is None:
            qs = Term.objects.all()
        
        thes = self.cleaned_data.get('thesaurus',None)
        if thes:
            qs = qs.filter(thesaurus=thes)
            
        lk_status = self.cleaned_data.get('link_status',-1)
        if lk_status>=0:
            qs = qs.filter(url_status=lk_status)
            
        validated = self.cleaned_data.get('validated', None)
        if validated is not None:
            qs = qs.filter(validated=validated)
            
        label_regexp = self.cleaned_data.get('label', None)
        if label_regexp:
            qs = qs.filter(label__iregex=label_regexp)
        
        order_by = self.cleaned_data.get('order_by', 'normalized_label') or 'normalized_label'
        order_dir = self.cleaned_data.get('order_dir', 'asc') or 'asc'
        if order_dir == 'desc':
            order_by = "-"+order_by
        qs = qs.order_by(order_by)
        
        return qs