from .views import TermListView, TermEditView, TermModifyWpLink, TermRemoveWpLink, TermValidate
from django.conf.urls import patterns, include, url
from django.contrib import admin
from django.contrib.auth.decorators import login_required
from django.contrib.auth import urls as auth_url
from jocondelab.views import TermListTableView

js_info_dict = {
    'packages': ('core', 'jocondelab'),
}

admin.autodiscover()

urlpatterns = patterns('',    
    url(r'^auth/', include(auth_url)),    
    url(r'^logout/$', 'django.contrib.auth.views.logout_then_login', name='joconde_logout'),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),
    url(r'^$', login_required(TermListView.as_view()), name='home'),
    url(r'^bo/term/list/table$', login_required(TermListTableView.as_view()), name='term_list_table'),
    url(r'^bo/term/(?P<term_id>\d+)/$', login_required(TermEditView.as_view()), name='term'),
    url(r'^bo/term/modify-wp/$', login_required(TermModifyWpLink.as_view()), name='modify_wp_link'),
    url(r'^bo/term/remove-wp/$', login_required(TermRemoveWpLink.as_view()), name='remove_wp_link'),
    url(r'^bo/term/validate/$', login_required(TermValidate.as_view()), name='validate_term'),    
)

