import platform

from lib_create_env import lib_generate_install_methods

system_str = platform.system()


INSTALLS = [ #(key,method, option_str, dict_extra_env)
    'SIX',
    'LIBJPEG',
    'ZLIB',    
    'REQUESTS',
    'SIMPLEJSON',
    'ISODATE',
    'PYPARSING',
    'HTML5LIB',
    'LXML',
    'PSYCOPG2',
    'SOUTH',
    'PIL', 
    'DJANGO',
    'DJANGO-EXTENSIONS',
    'HAYSTACK',
    'PYELASTICSEARCH',
    'PYTHON-DATEUTIL',
    'RDFLIB',
    'SQLALCHEMY',
    'RDFLIB-SQLALCHEMY',
    'WIKITOOLS',
    'MPTT',
]

if system_str == "Linux":
    INSTALLS.insert(2, 'DISTRIBUTE')

OPTIONS_TO_ADD = ['clear', 'type_install=local', 'unzip_setuptools']
if system_str != 'Linux':
    OPTIONS_TO_ADD.append('use_distribute')

def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS, OPTIONS_TO_ADD)
