from __future__ import unicode_literals

# About name_local: capitalize it as if your language name was appearing
# inside a sentence in your language.

LANG_INFO = {
    'af': {
        'bidi': False,
        'code': 'af',
        'name': 'Afrikaans',
        'name_local': 'Afrikaans',
    },
    'ar': {
        'bidi': True,
        'code': 'ar',
        'name': 'Arabic',
        'name_local': '\u0627\u0644\u0639\u0631\u0628\u064a\u0651\u0629',
    },
    'az': {
        'bidi': True,
        'code': 'az',
        'name': 'Azerbaijani',
        'name_local': 'az\u0259rbaycan dili',
    },
    'be': {
        'bidi': False,
        'code': 'be',
        'name': 'Belarusian',
        'name_local': '\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f',
    },
    'bg': {
        'bidi': False,
        'code': 'bg',
        'name': 'Bulgarian',
        'name_local': '\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438',
    },
    'bn': {
        'bidi': False,
        'code': 'bn',
        'name': 'Bengali',
        'name_local': '\u09ac\u09be\u0982\u09b2\u09be',
    },
    'br': {
        'bidi': False,
        'code': 'br',
        'name': 'Breton',
        'name_local': 'brezhoneg',
    },
    'bs': {
        'bidi': False,
        'code': 'bs',
        'name': 'Bosnian',
        'name_local': 'bosanski',
    },
    'ca': {
        'bidi': False,
        'code': 'ca',
        'name': 'Catalan',
        'name_local': 'catal\xe0',
    },
    'cs': {
        'bidi': False,
        'code': 'cs',
        'name': 'Czech',
        'name_local': '\u010desky',
    },
    'cy': {
        'bidi': False,
        'code': 'cy',
        'name': 'Welsh',
        'name_local': 'Cymraeg',
    },
    'da': {
        'bidi': False,
        'code': 'da',
        'name': 'Danish',
        'name_local': 'dansk',
    },
    'de': {
        'bidi': False,
        'code': 'de',
        'name': 'German',
        'name_local': 'Deutsch',
    },
    'el': {
        'bidi': False,
        'code': 'el',
        'name': 'Greek',
        'name_local': '\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac',
    },
    'en': {
        'bidi': False,
        'code': 'en',
        'name': 'English',
        'name_local': 'English',
    },
    'en-gb': {
        'bidi': False,
        'code': 'en-gb',
        'name': 'British English',
        'name_local': 'British English',
    },
    'eo': {
        'bidi': False,
        'code': 'eo',
        'name': 'Esperanto',
        'name_local': 'Esperanto',
    },
    'es': {
        'bidi': False,
        'code': 'es',
        'name': 'Spanish',
        'name_local': 'espa\xf1ol',
    },
    'es-ar': {
        'bidi': False,
        'code': 'es-ar',
        'name': 'Argentinian Spanish',
        'name_local': 'espa\xf1ol de Argentina',
    },
    'es-mx': {
        'bidi': False,
        'code': 'es-mx',
        'name': 'Mexican Spanish',
        'name_local': 'espa\xf1ol de Mexico',
    },
    'es-ni': {
        'bidi': False,
        'code': 'es-ni',
        'name': 'Nicaraguan Spanish',
        'name_local': 'espa\xf1ol de Nicaragua',
    },
    'es-ve': {
        'bidi': False,
        'code': 'es-ve',
        'name': 'Venezuelan Spanish',
        'name_local': 'espa\xf1ol de Venezuela',
    },
    'et': {
        'bidi': False,
        'code': 'et',
        'name': 'Estonian',
        'name_local': 'eesti',
    },
    'eu': {
        'bidi': False,
        'code': 'eu',
        'name': 'Basque',
        'name_local': 'Basque',
    },
    'fa': {
        'bidi': True,
        'code': 'fa',
        'name': 'Persian',
        'name_local': '\u0641\u0627\u0631\u0633\u06cc',
    },
    'fi': {
        'bidi': False,
        'code': 'fi',
        'name': 'Finnish',
        'name_local': 'suomi',
    },
    'fr': {
        'bidi': False,
        'code': 'fr',
        'name': 'French',
        'name_local': 'fran\xe7ais',
    },
    'fy-nl': {
        'bidi': False,
        'code': 'fy-nl',
        'name': 'Frisian',
        'name_local': 'Frisian',
    },
    'ga': {
        'bidi': False,
        'code': 'ga',
        'name': 'Irish',
        'name_local': 'Gaeilge',
    },
    'gl': {
        'bidi': False,
        'code': 'gl',
        'name': 'Galician',
        'name_local': 'galego',
    },
    'he': {
        'bidi': True,
        'code': 'he',
        'name': 'Hebrew',
        'name_local': '\u05e2\u05d1\u05e8\u05d9\u05ea',
    },
    'hi': {
        'bidi': False,
        'code': 'hi',
        'name': 'Hindi',
        'name_local': 'Hindi',
    },
    'hr': {
        'bidi': False,
        'code': 'hr',
        'name': 'Croatian',
        'name_local': 'Hrvatski',
    },
    'hu': {
        'bidi': False,
        'code': 'hu',
        'name': 'Hungarian',
        'name_local': 'Magyar',
    },
    'ia': {
        'bidi': False,
        'code': 'ia',
        'name': 'Interlingua',
        'name_local': 'Interlingua',
    },
    'id': {
        'bidi': False,
        'code': 'id',
        'name': 'Indonesian',
        'name_local': 'Bahasa Indonesia',
    },
    'is': {
        'bidi': False,
        'code': 'is',
        'name': 'Icelandic',
        'name_local': '\xcdslenska',
    },
    'it': {
        'bidi': False,
        'code': 'it',
        'name': 'Italian',
        'name_local': 'italiano',
    },
    'ja': {
        'bidi': False,
        'code': 'ja',
        'name': 'Japanese',
        'name_local': '\u65e5\u672c\u8a9e',
    },
    'ka': {
        'bidi': False,
        'code': 'ka',
        'name': 'Georgian',
        'name_local': '\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8',
    },
    'kk': {
        'bidi': False,
        'code': 'kk',
        'name': 'Kazakh',
        'name_local': '\u049a\u0430\u0437\u0430\u049b',
    },
    'km': {
        'bidi': False,
        'code': 'km',
        'name': 'Khmer',
        'name_local': 'Khmer',
    },
    'kn': {
        'bidi': False,
        'code': 'kn',
        'name': 'Kannada',
        'name_local': 'Kannada',
    },
    'ko': {
        'bidi': False,
        'code': 'ko',
        'name': 'Korean',
        'name_local': '\ud55c\uad6d\uc5b4',
    },
    'lb': {
        'bidi': False,
        'code': 'lb',
        'name': 'Luxembourgish',
        'name_local': 'L\u00ebtzebuergesch',
    },
    'lt': {
        'bidi': False,
        'code': 'lt',
        'name': 'Lithuanian',
        'name_local': 'Lithuanian',
    },
    'lv': {
        'bidi': False,
        'code': 'lv',
        'name': 'Latvian',
        'name_local': 'latvie\u0161u',
    },
    'mk': {
        'bidi': False,
        'code': 'mk',
        'name': 'Macedonian',
        'name_local': '\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438',
    },
    'ml': {
        'bidi': False,
        'code': 'ml',
        'name': 'Malayalam',
        'name_local': 'Malayalam',
    },
    'mn': {
        'bidi': False,
        'code': 'mn',
        'name': 'Mongolian',
        'name_local': 'Mongolian',
    },
    'nb': {
        'bidi': False,
        'code': 'nb',
        'name': 'Norwegian Bokmal',
        'name_local': 'norsk (bokm\xe5l)',
    },
    'ne': {
        'bidi': False,
        'code': 'ne',
        'name': 'Nepali',
        'name_local': '\u0928\u0947\u092a\u093e\u0932\u0940',
    },
    'nl': {
        'bidi': False,
        'code': 'nl',
        'name': 'Dutch',
        'name_local': 'Nederlands',
    },
    'nn': {
        'bidi': False,
        'code': 'nn',
        'name': 'Norwegian Nynorsk',
        'name_local': 'norsk (nynorsk)',
    },
    'no': {
        'bidi': False,
        'code': 'no',
        'name': 'Norwegian',
        'name_local': 'norsk',
    },
    'pa': {
        'bidi': False,
        'code': 'pa',
        'name': 'Punjabi',
        'name_local': 'Punjabi',
    },
    'pl': {
        'bidi': False,
        'code': 'pl',
        'name': 'Polish',
        'name_local': 'polski',
    },
    'pt': {
        'bidi': False,
        'code': 'pt',
        'name': 'Portuguese',
        'name_local': 'Portugu\xeas',
    },
    'pt-br': {
        'bidi': False,
        'code': 'pt-br',
        'name': 'Brazilian Portuguese',
        'name_local': 'Portugu\xeas Brasileiro',
    },
    'ro': {
        'bidi': False,
        'code': 'ro',
        'name': 'Romanian',
        'name_local': 'Rom\xe2n\u0103',
    },
    'ru': {
        'bidi': False,
        'code': 'ru',
        'name': 'Russian',
        'name_local': '\u0420\u0443\u0441\u0441\u043a\u0438\u0439',
    },
    'sk': {
        'bidi': False,
        'code': 'sk',
        'name': 'Slovak',
        'name_local': 'slovensk\xfd',
    },
    'sl': {
        'bidi': False,
        'code': 'sl',
        'name': 'Slovenian',
        'name_local': 'Sloven\u0161\u010dina',
    },
    'sq': {
        'bidi': False,
        'code': 'sq',
        'name': 'Albanian',
        'name_local': 'Albanian',
    },
    'sr': {
        'bidi': False,
        'code': 'sr',
        'name': 'Serbian',
        'name_local': '\u0441\u0440\u043f\u0441\u043a\u0438',
    },
    'sr-latn': {
        'bidi': False,
        'code': 'sr-latn',
        'name': 'Serbian Latin',
        'name_local': 'srpski (latinica)',
    },
    'sv': {
        'bidi': False,
        'code': 'sv',
        'name': 'Swedish',
        'name_local': 'svenska',
    },
    'sw': {
        'bidi': False,
        'code': 'sw',
        'name': 'Swahili',
        'name_local': 'Kiswahili',
    },
    'ta': {
        'bidi': False,
        'code': 'ta',
        'name': 'Tamil',
        'name_local': '\u0ba4\u0bae\u0bbf\u0bb4\u0bcd',
    },
    'te': {
        'bidi': False,
        'code': 'te',
        'name': 'Telugu',
        'name_local': '\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41',
    },
    'th': {
        'bidi': False,
        'code': 'th',
        'name': 'Thai',
        'name_local': 'Thai',
    },
    'tr': {
        'bidi': False,
        'code': 'tr',
        'name': 'Turkish',
        'name_local': 'T\xfcrk\xe7e',
    },
    'tt': {
        'bidi': False,
        'code': 'tt',
        'name': 'Tatar',
        'name_local': '\u0422\u0430\u0442\u0430\u0440\u0447\u0430',
    },
    'udm': {
        'bidi': False,
        'code': 'udm',
        'name': 'Udmurt',
        'name_local': '\u0423\u0434\u043c\u0443\u0440\u0442',
    },
    'uk': {
        'bidi': False,
        'code': 'uk',
        'name': 'Ukrainian',
        'name_local': '\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430',
    },
    'ur': {
        'bidi': False,
        'code': 'ur',
        'name': 'Urdu',
        'name_local': '\u0627\u0631\u062f\u0648',
    },
    'vi': {
        'bidi': False,
        'code': 'vi',
        'name': 'Vietnamese',
        'name_local': 'Vietnamese',
    },
    'zh-cn': {
        'bidi': False,
        'code': 'zh-cn',
        'name': 'Simplified Chinese',
        'name_local': '\u7b80\u4f53\u4e2d\u6587',
    },
    'zh-tw': {
        'bidi': False,
        'code': 'zh-tw',
        'name': 'Traditional Chinese',
        'name_local': '\u7e41\u9ad4\u4e2d\u6587',
    }
}
