# -*- coding: utf-8 -*-
'''
Created on Jul 31, 2013

@author: ymh
'''
from django.db import models
from core.models import Thesaurus, Notice, Term

class ContributedTerm(models.Model):
    
    created_at = models.DateTimeField(auto_now_add=True)
    dbpedia_uri = models.URLField(max_length=2048, unique=True, blank=False, null=False, db_index=True)
    dbpedia_language = models.CharField(max_length=15, blank=False, null=False, db_index=True)

    class Meta:
        app_label = 'jocondelab'
    
    def __unicode__(self):
        return self.dbpedia_uri

class ContributedFields(models.Model):
    
    term = models.ForeignKey(ContributedTerm, blank=False, null=False, db_index=True, related_name="dbpedia_fields")
    dbpedia_uri = models.URLField(max_length=2048, blank=False, null=False, db_index=True, unique=False)
    language_code = models.CharField(max_length=15, blank=False, null=False, db_index=True)
    thumbnail = models.URLField(max_length=2048, blank=True, null=True, db_index=False)    
    label = models.CharField(max_length=2048, unique=False, blank=True, null=True)
    abstract = models.TextField(blank=True, null=True)
    
    class Meta:
        app_label = 'jocondelab'
    
    def __unicode__(self):
        return u'"%s"@%s'%(self.label, self.language_code)

class Contribution(models.Model):
    
    term = models.ForeignKey(ContributedTerm, blank=False, null=False, db_index=True, related_name="contributions")
    thesaurus = models.ForeignKey(Thesaurus, blank=True, null=True, db_index=True)
    notice = models.ForeignKey(Notice, blank=False, null=False, db_index=True)
    contribution_count = models.IntegerField(blank=False, null=False, default=0, db_index=True, editable=False)
    
    class Meta:
        app_label = 'jocondelab'
        
    def __unicode__(self):
        return u'%s, %s, %s'%((self.notice.titr or self.notice.deno),self.term.dbpedia_uri,(self.thesaurus.label if self.thesaurus else "Folksonomy"))

class ContributableTerm(models.Model):
    
    term = models.ForeignKey(Term, blank=False, null=False, db_index=True, unique=True)
    
    class Meta:
        app_label = 'jocondelab'
    
    def __unicode__(self):
        return self.term.label