from .models import User
from django.conf import settings
from django.contrib import admin
from django.contrib.auth.admin import UserAdmin as AuthUserAdmin
from django.contrib.auth.forms import UserChangeForm as AuthUserChangeForm 
from django.forms.fields import ChoiceField
from django.utils.translation import gettext_lazy as _


class UserChangeForm(AuthUserChangeForm):
    language = ChoiceField(label=_("language"), choices=[(k,_(v)) for k,v in settings.LANGUAGES], initial=settings.LANGUAGE_CODE[:2])
    class Meta:
        model = User

class UserAdmin(AuthUserAdmin):
    form = UserChangeForm
    fieldsets = tuple(list(AuthUserAdmin.fieldsets) + [(_('language'), {'fields':('language',)})])


admin.site.register(User, UserAdmin)
