﻿// -*- coding: utf-8 -*-
function init_term_events()
{
    // Tag simple operations : activate/unactivate wp link, remove wp link
    $(".remove_wp_link").click(function(e){
        if(confirm("Confirmez-vous le suppression du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?")){
            delete_link(this);
        }
    });
    
    // Wikipedia search management (new tag)
    $("#wp_search").autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "http://fr.wikipedia.org/w/api.php",
                dataType: "jsonp",
                data: {
                    action: "opensearch",
                    limit: "20",
                    namespace: "0",
                    format: "json",
                    search: request.term
                },
                success: function( data ) {
                    response( $.map( data[1], function( item ) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        select: function(event, ui) { 
            // Since the event still did not update wp_search's val, we force it.
            $("#wp_search").val(ui.item.label);
            select_done = true;
            $("#ok_search").click();
        },
        minLength: 2,
        open: function() {
            $( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
        },
        close: function() {
            $( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
        }
    });
    $('#wp_search').keyup(function(e){
        if((e.keyCode==13) && ($("#wp_search").val()!="") && (select_done==false)){
            update_link($("#wp_search").val());
        }
        select_done = false;
    });
    $("#ok_search").click(function(){
        if($("#wp_search").val()!=""){
            update_link($("#wp_search").val());
        }
    });
    // Validate sheet management : the radiobutton name has is "'gr_validated' + datasheet.hda_id"
    $("#validated").click(function(e){
        e.preventDefault();
        if(confirm("Confirmez-vous la validation de ce terme ?")){
            $.post(validate_term_url,{term_id: term_id, validation_val: 'True', csrfmiddlewaretoken: global_csrf_token},function(data) {
                window.location.reload(true);
            });
        }
    });
    $("#not_validated").click(function(e){
        e.preventDefault();
        if(confirm("Confirmez-vous l'invalidation de cette fiche ?")){
            $.post(validate_term_url,{term_id: term_id, validation_val: 'False', csrfmiddlewaretoken: global_csrf_token},function(data) {
                window.location.reload(true);
            });
        }
    });    
}


function delete_link(btn)
{
    if ($(btn).is(".remove_wp_link")) {
        var url = remove_wp_link_url;
        var term_id = $(btn).attr('id');
    }

    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               term_id:term_id,
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
		error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
			$(btn).html(id_tag);
		}
    });
}

function update_link(tag_label)
{
    $("#ok_search").html("<img src='"+static_url+"jocondelab/img/indicator.gif'>");
    var url = modify_wp_link_url;
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               term_id:term_id,
               label:tag_label
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            window.location.reload(true);
        },
        error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			console.log(resp.message);
        },
        complete: function(){
            // We empty the input and hide the ok button
            $("#wp_search").val("");
            $("#ok_search").html("<b>OK</b>");
        }
    });
}


