import logging

from notes.models import Note, Session
from rest_framework import viewsets, serializers

from ..permissions import NotePermission, SessionPermission
from ..serializers.core import (DetailNoteSerializer, UpdateNoteSerializer, DetailSessionSerializer, CreateNoteSerializer,
                                ListNoteSerializer, ListSessionSerializer, CreateSessionSerializer)

logger = logging.getLogger(__name__)


class SessionViewSet(viewsets.ModelViewSet):
    """
    API endpoint that allow sessions ro be viewed or edited
    """
    serializer_class = ListSessionSerializer
    lookup_field = 'ext_id'

    serializers = {
        'list': ListSessionSerializer,
        'retrieve':  DetailSessionSerializer,
        'create':  CreateSessionSerializer,
    }

    permission_classes = (SessionPermission,)

    def get_serializer_class(self):
        return self.serializers.get(self.action, ListSessionSerializer)

    def get_queryset(self):
        return Session.objects.filter(owner=self.request.user)


class NoteViewSet(viewsets.ModelViewSet):

    serializers = {
        'list': ListNoteSerializer,
        'retrieve': DetailNoteSerializer,
        'create': CreateNoteSerializer,
        'update': UpdateNoteSerializer,
    }
    lookup_field = 'ext_id'

    permission_classes = (NotePermission,)

    def get_serializer_class(self):
        return self.serializers.get(self.action, ListNoteSerializer)

    def get_queryset(self):
        return Note.objects.filter(
            session__ext_id=self.kwargs['session_ext_id'],
            session__owner=self.request.user)
