import React, { Component } from 'react';
import ReactDOM from 'react-dom';

export default class NavbarGroup extends Component {

  state = {
    showDropdown: false
  }

  componentWillMount() {
    document.addEventListener('click', this.handleClickOutside, false);
  }

  componentWillUnmount() {
    document.removeEventListener('click', this.handleClickOutside, false);
  }

  handleClickOutside = (e) => {
    if(!ReactDOM.findDOMNode(this).contains(e.target)) {
      this.hideDropDown();
    }
  }

  toggleShowDropdown = () => {
    this.setState({showDropdown: !this.state.showDropdown});
  }

  hideDropDown = () => {
    this.setState({showDropdown: false});
  }

  render() {

    const {currentGroup, groups, onSelect} = this.props;

    const onClickGroup = (e) => {
      onSelect(e.target.dataset.groupname);
      this.hideDropDown();
    }

    if (currentGroup) {
      const currentGroupName = currentGroup.get('name');
      return (
        <li className={`nav-item dropdown navs ${this.state.showDropdown?'show':''}`}>
          <a className="nav-link dropdown-toggle" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded={this.state.showDropdown} onClick={this.toggleShowDropdown} onBlur={this.hideDropDown}>
          { currentGroupName }
          &nbsp;<span className="caret"></span>
          </a>
          <ul className={`dropdown-menu ${this.state.showDropdown?'show':''}`} aria-labelledby="navbarDropdown">
          { groups && groups.map((group, key) => {
            const groupName = group.get('name');
            const className = (groupName === currentGroupName)?'active':null;
              return <li key={key} className={className} onClick={onClickGroup}><a data-groupname={groupName}>{ groupName }</a></li>
            })
          }
          <li onClick={onClickGroup} key="-1"><a data-groupname="__create_group__">Créer un groupe...</a></li>
          </ul>
        </li>
      );
    } else {
      return null;
    }
  }
}
