import '../index.css';
import './Navbar.css';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router';
import { bindActionCreators } from 'redux';
// import logo from './logo.svg';
import Modal from 'react-modal';
import * as authActions from '../actions/authActions';
import { forceSync } from '../actions/networkActions';
import { groupSetCurrent } from '../actions/groupActions';
import { isAuthenticated, getCurrentUser, getOnline, getCurrentGroup, getGroups } from '../selectors/authSelectors';
import { isSynchronizing, isSynchronized } from '../selectors/syncSelectors';
import NavbarLogin from './NavbarLogin';
import NavbarGroup from './NavbarGroup';

const Online = ({ online }) => {
  return (
    <li>
      <a>
        <span  className="material-icons navs" style={{ color: online ? '#2ECC71' : '#F95B5B' }}>signal_wifi_4_bar</span>
      </a>
    </li>
  )
}

const SyncButton = ({ isAuthenticated, onSyncClick, isSynchronizing, isSynchronized, id }) => {
  const classnames = "material-icons"
    + ((!isSynchronized)?" sync-button-not-synchronized":"")
    + ((isSynchronizing)?" sync-button-synchronizing":"");
  let title = "Synchronize";
  let clickCb = onSyncClick;
  if(isSynchronizing) {
    title = "Synchronizing...";
    clickCb = () => {};
  } else if (!isSynchronized) {
    title += ": not synchronized";
  }

  if (isAuthenticated) {
    return (
      <li>
        <a title={title} onClick={clickCb} id={id || null}>
        <span className={classnames}>&#xE627;</span> </a>
      </li>
    );
  }
  return (
      <li>
        <a>
          <span></span>
        </a>
    </li>
  );
}


class AppNavbar extends Component {
  constructor(props) {
    super(props);
    this.state = { modalIsOpen: false };
  }

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({modalIsOpen: false});
  }

  onClickHome = (e) => {
    e.preventDefault();
    this.props.history.push('/');
  }

  isSynchronized = () => {
    return this.props.isSynchronized;
  }

  onClickLogout = (e) => {
    e.preventDefault();
    const isSynchronized = this.isSynchronized();
    if (isSynchronized) {
      this.logout();
    } else {
      this.openModal()
    }
  }

  confirmLogout = () => {
    const isSynchronized = this.isSynchronized();
    if (!isSynchronized) {
      this.props.authActions.resetAll();
    }
    this.logout();
    this.closeModal();
  }

  logout = () => {
    this.props.authActions.logout();
    this.props.history.push('/');
  }

  onClickSessions = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }

  onSyncClick = (e) => {
    e.preventDefault();
    this.props.networkActions.forceSync();
  }

  onGroupSelect = (groupName) => {
    if(groupName === "__create_group__") {
      this.props.history.push('/create-group');
    } else {
      this.props.groupActions.groupSetCurrent(groupName);
    }
  }

  render() {
    return (
      <nav className="navbar navbar-inverse navbar-fixed-top">
        <div className="container-fluid">
          <div className="navbar-header">
            <a id="brand" className="navbar-brand" onClick={this.onClickHome} href="/">IRI Notes</a>
            <button type="button" className="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
              <span className="sr-only">Toggle navigation</span>
              <span className="icon-bar"></span>
              <span className="icon-bar"></span>
              <span className="icon-bar"></span>
            </button>
          </div>
          <div className="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
            <ul className="nav navbar-nav">
              <li>
                <a className="navs" onClick={this.onClickSessions} href="/sessions">Accueil</a>
              </li>
            </ul>
            <ul className="nav navbar-nav navbar-right">
              <NavbarGroup currentGroup={this.props.currentGroup} groups={this.props.groups} onSelect={this.onGroupSelect}/>
              <SyncButton id='sync-button' isAuthenticated={this.props.isAuthenticated} onSyncClick={this.onSyncClick} isSynchronizing={this.props.isSynchronizing} isSynchronized={this.props.isSynchronized} />
              <Online {...this.props} />
              <NavbarLogin {...this.props} onLogout={this.onClickLogout} />
            </ul>
          </div>
          <Modal
          className="Modal__Bootstrap modal-dialog"
          // closeTimeoutMS={150}
          isOpen={this.state.modalIsOpen}
          onRequestClose={this.handleModalCloseRequest}
          >
            <div className="modal-content">
              <div className="modal-body">
                <p className="text-center">
                  Certaines données n'ont pas encore été sauvegardées.
                  <br />
                  Si vous continuez, elles seront perdues.
                </p>
              </div>
              <div className="modal-footer">
                <button type="submit" className="btn btn-primary btn-lg" onClick={this.confirmLogout}>Confirmer</button>
                <button type="submit" className="btn btn-default btn-lg" onClick={this.handleModalCloseRequest}>Fermer</button>
              </div>
            </div>
          </Modal>
        </div>
      </nav>

    );
  }
}

AppNavbar.propTypes = {
  isAuthenticated: PropTypes.bool.isRequired
};

function mapStateToProps(state, props) {
  return {
    isAuthenticated: isAuthenticated(state),
    currentUser: getCurrentUser(state),
    online: getOnline(state),
    isSynchronizing: isSynchronizing(state),
    isSynchronized: isSynchronized(state),
    currentGroup: getCurrentGroup(state),
    groups: getGroups(state)
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
    networkActions: bindActionCreators({ forceSync }, dispatch),
    groupActions: bindActionCreators({ groupSetCurrent }, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(withRouter(AppNavbar));
