import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Modal from 'react-modal';
import moment from 'moment';
import '../App.css';
import './SessionList.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';
import uuidV1 from 'uuid/v1';
import { getActiveSessions } from '../selectors/coreSelectors';
import { getCurrentUser, getGroups, getCurrentGroup } from '../selectors/authSelectors';

class SessionList extends Component {

  constructor(props) {
    super(props);
    this.state = {
      modalIsOpen: false,
      sessionToDelete: null,
    };
  }

  openModal = () => {
    this.setState({modalIsOpen: true});
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = () => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    this.setState({modalIsOpen: false});
  }

  createSession = () => {
    const sessionId = uuidV1();
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
        }
      }
    }

    this.props.sessionsActions.createSession(sessionId, groupName, protocol);
    this.props.history.push('/sessions/' + sessionId);
  }

  onClickDelete(session, e) {
    e.preventDefault();
    e.stopPropagation();


    this.setState({
      modalIsOpen: true,
      sessionToDelete: session
    })
  }

  deleteSession = () => {
    const { sessionToDelete } = this.state;

    this.props.sessionsActions.deleteSession(sessionToDelete);

    this.setState({
      modalIsOpen: false,
      sessionToDelete: null
    })
  }

  render() {
    return (
      <div>
        <button id="session-button" type="button" className="btn btn-primary btn-lg" onClick={this.createSession}>Créer une nouvelle session</button>
        <Navbar history={this.props.history} />
        <div className="container-fluid">
          <div className="row">
                {this.props.sessions.map((session) =>
                <a className="sessions" href="#session" key={"session_"+session.get('_id')} onClick={() => this.props.history.push('/sessions/' + session.get('_id'))}>
                  <div className="col-md-4 session" key={session.get('_id')}>
                    <span className="session-title">{session.title || ''}<br /></span>
                    <span className="session-date text-muted">{moment(session.get('date')).format('DD/MM/YYYY')}<br /></span>
                    <span className="session-description">{session.description}<br /></span>
                    <a href="#delete" className="pull-right" onClick={ this.onClickDelete.bind(this, session) }>
                      <span className="material-icons">delete</span>
                    </a>
                  </div>
                </a>
                )}
               </div>
          </div>
        <Modal
        className="Modal__Bootstrap modal-dialog"
        // closeTimeoutMS={150}
        isOpen={this.state.modalIsOpen}
        onRequestClose={this.handleModalCloseRequest}
        >
          <div className="modal-content">
            <div className="modal-body">
            Êtes-vous sûr(e) ?
            </div>
            <div className="modal-footer">
              <button type="button" className="btn btn-primary btn-lg" onClick={ this.deleteSession }>Confirmer</button>
              <button type="button" className="btn btn-default btn-lg" onClick={ this.handleModalCloseRequest }>Fermer</button>
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}



function mapStateToProps(state, props) {
  return {
    sessions: getActiveSessions(state),
    currentUser: getCurrentUser(state),
    groups: getGroups(state),
    currentGroup: getCurrentGroup(state)
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionList);
